//
//  TVCPlayerControlViewController.m
//  TencentVideoCut
//
//  Created by jianyongluo on 2020/12/28.
//  Copyright © 2021 Tencent. All rights reserved.
//

#import "TVCPlayerControlViewController.h"
#import "Masonry/Masonry.h"
//#import "NSString+TVCUtil.h"
//#import "UIFont+TAVUtil.h"
//#import "TAVEditorUIConfig.h"
/// 主页的播放按钮图标名称
static NSString * const gTAVEditHomePlayIconName = @"icon_edit_player_play_normal";
/// 主页的暂停按钮图标名称
static NSString * const gTAVEditHomePauseIconName = @"icon_edit_player_pause_normal";
/// 主页的撤销按钮可用状态图标名称
static NSString * const gTAVEditHomeRevokeNormalIconName = @"icon_edit_player_revoke_normal";
/// 主页的恢复按钮禁用状态图标名称
static NSString * const gTAVEditHomeRevokeDisableIconName = @"icon_edit_player_revoke_disable";
/// 主页的恢复按钮可用状态图标名称
static NSString * const gTAVEditHomeRestoreNormalIconName = @"icon_edit_player_restore_normal";
/// 主页的恢复按钮禁用状态图标名称
static NSString * const gTAVEditHomeRestoreDisableIconName = @"icon_edit_player_restore_disable";
/// 主页的全屏按钮图标名称
static NSString * const gTAVEditHomeFullScreenIconName = @"icon_edit_player_full_screen";

@interface TVCPlayerControlViewController ()

@property (nonatomic, strong, readwrite) UILabel *nowDurationLabel; // 当前播放时间点
@property (nonatomic, strong, readwrite) UILabel *totalDurationLabel; // 总时长
@property (nonatomic, strong, readwrite) UIButton *playButton; // 播放
@property (nonatomic, strong, readwrite) UIButton *undoButton; // 撤销
@property (nonatomic, strong, readwrite) UIButton *redoButton; // 恢复
@property (nonatomic, strong, readwrite) UIButton *fullScreenButton; // 全屏

@end

@implementation TVCPlayerControlViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

- (void)setupUI {
    UIView *rootView = self.view;
    
    UILabel *nowDurationLabel = [UILabel new];
    nowDurationLabel.text = [NSString stringWithFormat:@"%@",@"00:00"];
    nowDurationLabel.font = [UIFont systemFontOfSize:12];
    nowDurationLabel.textColor = [UIColor whiteColor];
    nowDurationLabel.textAlignment = NSTextAlignmentRight;
    self.nowDurationLabel = nowDurationLabel;
    [rootView addSubview:nowDurationLabel];
    
    UILabel *lineLabel = [UILabel new];
    lineLabel.text = [NSString stringWithFormat:@"/"];
    lineLabel.font = [UIFont systemFontOfSize:11];
    lineLabel.textColor = [UIColor whiteColor];
    lineLabel.textAlignment = NSTextAlignmentLeft;
    [rootView addSubview:lineLabel];
    
    UILabel *totalDurationLabel = [UILabel new];
    totalDurationLabel.text = [NSString stringWithFormat:@"%@",@"00:00"];
    totalDurationLabel.font = [UIFont systemFontOfSize:12];
    totalDurationLabel.textColor = [[UIColor whiteColor] colorWithAlphaComponent:0.4];
    totalDurationLabel.textAlignment = NSTextAlignmentLeft;
    self.totalDurationLabel = totalDurationLabel;
    [rootView addSubview:totalDurationLabel];
    
    UIButton *playButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [playButton setImage:[UIImage imageNamed:gTAVEditHomePlayIconName] forState:UIControlStateNormal];
    [playButton setImage:[UIImage imageNamed:gTAVEditHomePauseIconName] forState:UIControlStateSelected];
    self.playButton = playButton;
    [rootView addSubview:playButton];
    
    UIButton *undoButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [undoButton setImage:[UIImage imageNamed:gTAVEditHomeRevokeNormalIconName] forState:UIControlStateNormal];
    [undoButton setImage:[UIImage imageNamed:gTAVEditHomeRevokeDisableIconName] forState:UIControlStateDisabled];
    self.undoButton = undoButton;
    [rootView addSubview:undoButton];
    
    UIButton *redoButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [redoButton setImage:[UIImage imageNamed:gTAVEditHomeRestoreNormalIconName] forState:UIControlStateNormal];
    [redoButton setImage:[UIImage imageNamed:gTAVEditHomeRestoreDisableIconName] forState:UIControlStateDisabled];
    self.redoButton = redoButton;
    [rootView addSubview:redoButton];
    
    UIButton *fullScreenButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [fullScreenButton setImage:[UIImage imageNamed:gTAVEditHomeFullScreenIconName] forState:UIControlStateNormal];
    [fullScreenButton setImage:[UIImage imageNamed:gTAVEditHomeFullScreenIconName] forState:UIControlStateSelected];
    self.fullScreenButton = fullScreenButton;
    [rootView addSubview:fullScreenButton];
    
    [self.nowDurationLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.centerY.mas_equalTo(rootView);
        make.right.mas_equalTo(lineLabel.mas_left).offset(-4);
    }];
    [lineLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(51);
        make.centerY.mas_equalTo(rootView);
    }];
    [self.totalDurationLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(lineLabel.mas_right).offset(4);
        make.centerY.mas_equalTo(rootView);
        make.width.mas_lessThanOrEqualTo(55);
    }];
    [playButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(34);
        make.height.mas_equalTo(34);
        make.center.equalTo(rootView);
    }];
    [fullScreenButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(23);
        make.right.mas_equalTo(rootView).offset(-10);
        make.centerY.mas_equalTo(rootView);
    }];
    [redoButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(23);
        make.right.mas_equalTo(fullScreenButton.mas_left).offset(-16);
        make.centerY.mas_equalTo(rootView);
    }];
    [undoButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(23);
        make.right.mas_equalTo(redoButton.mas_left).offset(-18);
        make.centerY.mas_equalTo(rootView);
    }];
    undoButton.hidden = YES;
    redoButton.hidden = YES;
    fullScreenButton.hidden = YES;
}

- (void)updateTotalDurationLabelWithTime:(NSTimeInterval)time {
    self.totalDurationLabel.text = [self tvc_formattedTimeStringWithTime:time];
}

- (void)updateNowDurationLabelWithTime:(NSTimeInterval)time {
    self.nowDurationLabel.text = [self tvc_formattedTimeStringWithTime:time];
}

- (NSString *)tvc_formattedTimeStringWithTime:(NSTimeInterval)time {
    // 以 00:00 格式显示
    NSTimeInterval duration = ceil(time);
    long minute = (long)(duration / 60);
    long second = (long)duration % 60;
    return [NSString stringWithFormat:@"%02ld:%02ld", minute, second];
}

@end
