//
//  TestPlayerViewController.m
//  TAVMagicDemo
//
//  Created by chavezchen on 2023/12/6.
//

#import "TestPlayerViewController.h"
#import "Masonry/Masonry.h"
#import "TVCPlayerControlViewController.h"
#import <TAVMagic/ITAVStickerManager.h>
#import <TAVMagic/ITAVPipManager.h>
#import <TAVMagic/TAVMediaPipItem.h>

@interface TestPlayerViewController ()<TAVEditorPlayerObserver,UITableViewDataSource,UITableViewDelegate>
@property (nonatomic, strong, readwrite) TVCPlayerControlViewController *controlController;
@property (nonatomic, strong) UITableView *myTbaleView;
@property (nonatomic, copy) NSArray *titles;
@property (nonatomic, copy) NSArray *funcNames;
@property (nonatomic, strong) UILabel *tipsLabel;
@end

@implementation TestPlayerViewController

- (void)viewDidLoad {
    [super viewDidLoad];
        
    TVCPlayerControlViewController *controlController = [[TVCPlayerControlViewController alloc] init];
    self.controlController = controlController;
    [self addChildViewController:controlController];
    [self.view addSubview:controlController.view];
    [controlController didMoveToParentViewController:self];
    controlController.view.backgroundColor = [UIColor blackColor];
    //layout
    [controlController.view mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(self.view);
        make.bottom.mas_equalTo(-40);
        make.height.mas_equalTo(36);
    }];
    
    TAVPreviewParam *param = [[TAVPreviewParam alloc] init];
    param.videoView = self.view;
    param.fillModel = TAVPlayerFillModeAspectFit;
    param.observer = self;
    param.loop = YES;
    [self.tavEditor setPreview:param];
    [self.tavEditor flushImmediately];
    
    [self.view bringSubviewToFront:controlController.view];
    [self setPlayerActions];
    
    self.titles = @[@"修改音量",@"增加BGM",@"旋转",@"滤镜",@"贴纸",@"特效",@"转场",@"模板",@"画中画",@"保存视频"];
    self.funcNames = @[@"updateVolume",@"addAudioRes",@"rotationTest",@"lutTest",@"imageStickerTest",@"bgEffectTest",@"transitionTest",@"templateTest",@"pipTest",@"generateVideo"];
    UITableView *tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 0, 100, 100) style:UITableViewCellStyleDefault];
    [self.view addSubview:tableView];
    self.myTbaleView = tableView;
    self.myTbaleView.dataSource = self;
    self.myTbaleView.delegate = self;
    self.myTbaleView.rowHeight = 32;
    [self.myTbaleView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(0);
        make.width.mas_equalTo(100);
        make.height.mas_equalTo(300);
        make.centerY.mas_equalTo(0);
    }];
//    self.myTbaleView.backgroundColor = [UIColor redColor];
    self.myTbaleView.alpha = 0.5;
    
    self.tipsLabel = [[UILabel alloc] init];
    self.tipsLabel.backgroundColor = [UIColor grayColor];
    self.tipsLabel.alpha = 0.9;
    [self.view addSubview:self.tipsLabel];
    [self.tipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.mas_equalTo(0);
    }];
    
}

- (void)setPlayerActions {
    [self.controlController.playButton addTarget:self
                                          action:@selector(playAction:)
                                forControlEvents:UIControlEventTouchUpInside];
}


- (void)playAction:(UIButton *)sender {
    if (self.tavEditor.isPlaying) {
        [self.tavEditor pause];
    } else {
        [self.tavEditor play];
    }
}

- (void)updateTimeRangeTest
{
    [self.tavEditor setClipRange:CMTimeRangeMake(kCMTimeZero, CMTimeMakeWithSeconds(5, 600)) index:0];
}

- (void)updateVolume
{
    [self.tavEditor setClipVolume:0.1 index:0];
}

- (void)updateIndex {
    [self.tavEditor updateClipIndex:1 toIndex:3];
}

- (void)addAudioRes {
    NSString *audioPath1 = [[NSBundle mainBundle] pathForResource:@"bgm1" ofType:@"m4a"];
    [self.tavEditor addBgm:audioPath1 startAtVideoTime:kCMTimeZero timeRange:CMTimeRangeMake(CMTimeMakeWithSeconds(14, 600), CMTimeMakeWithSeconds(15, 600))];
    [self.tavEditor addBgm:audioPath1 startAtVideoTime:CMTimeMakeWithSeconds(15, 600) timeRange:CMTimeRangeMake(CMTimeMakeWithSeconds(14, 600), CMTimeMakeWithSeconds(15, 600))];
    [self.tavEditor flushImmediately];
}

- (void)seekTest {
    [self.tavEditor seekToTime:CMTimeMakeWithSeconds(14, 600)];
}

- (void)rotationTest {
    [self.tavEditor setClipsRotation:30];
    [self.tavEditor flushImmediately];
}

static int _lutId1;
- (void)lutTest
{
    NSString *path = [[NSBundle mainBundle] pathForResource:@"filter_fengjing_qiufenmu" ofType:@"png"];
    
    _lutId1 = [self.tavEditor addFilter:path strength:0.8 timeRange:CMTimeRangeMake(kCMTimeZero, CMTimeMakeWithSeconds(5, 600))];
}

static int _stickerId;
- (void)imageStickerTest {
    NSString *stickerPath = [[NSBundle mainBundle] pathForResource:@"style_plfttz" ofType:@"bundle"];
    id<ITAVStickerManager> stickerManager = [self.tavEditor getStickerManager];
    TAVMediaStickerItem *stickerItem = [stickerManager createStickerItem:stickerPath stickerType:TAVStickerItemTypeMotion];
    [stickerManager loadStickerItem:stickerItem];
}

static int _effectId;
- (void)bgEffectTest {
    NSString *filePath = [[NSBundle mainBundle] pathForResource:@"fenseaixin_pag" ofType:@"pag"];
    _effectId = [self.tavEditor addMotionEffect:filePath timeRange:CMTimeRangeMake(kCMTimeZero, self.tavEditor.getTotalDuration)];
}

- (void)effectUpdate {
    [self.tavEditor updateMotionEffect:_effectId playRange:CMTimeRangeMake(kCMTimeZero, self.tavEditor.getTotalDuration)];
}

- (void)transitionTest {
    NSString *filePath = [[NSBundle mainBundle] pathForResource:@"texiao_horizontal_open" ofType:@"bundle"];
    filePath = [filePath stringByAppendingPathComponent:@"horizontal_open_pag.pag"];
    [self.tavEditor addMotionEffect:filePath timeRange:CMTimeRangeMake(kCMTimeZero, CMTimeMakeWithSeconds(1.5, 600))];
}

- (void)templateTest {
    NSString *templatePath = [[NSBundle mainBundle] pathForResource:@"danpian_guangchi" ofType:@"bundle"];
    // 获取模版配置信息，根据配置信息添加对应的clip资源
    TAVTemplateConfig *config = [self.tavEditor getTemplateConfig:templatePath];
    [self.tavEditor setTemplate:templatePath];
    [self.tavEditor play];
}

- (void)pipTest {
    NSString *videoPath = [[NSBundle mainBundle] pathForResource:@"test" ofType:@"mp4"];
    TAVMediaPipItem *pipItem = [[self.tavEditor getPipManager] createPipItem:videoPath mediaType:0];
    pipItem.startTime = kCMTimeZero;
    [[self.tavEditor getPipManager] loadPip:pipItem];
}

- (void)generateVideo
{
    NSString *tempDir = NSTemporaryDirectory();
    NSString *appLib = [tempDir stringByAppendingString:@"/Caches"];
    NSString *resDir = [appLib stringByAppendingPathComponent:@"tavXmagic"];
//    NSString *dstPath = [resDir stringByAppendingPathComponent:@"test.mp4"];

    
    TAVEditorGenerateConfig *config = [[TAVEditorGenerateConfig alloc] init];
    self.tipsLabel.hidden = NO;
    self.tipsLabel.text = @"开始导出";
    [self.tavEditor generateVideo:config outputPath:resDir progress:^(CGFloat progress) {
        NSLog(@"progress : %f",progress);
        self.tipsLabel.text = [NSString stringWithFormat:@"%f%%",progress * 100];
    } completion:^(NSError * _Nonnull error, NSString * _Nonnull outputPath) {
        if (error) {
            NSLog(@"generateVideo error : %@",error);
            self.tipsLabel.text = @"导出失败";
            return;
        }
        self.tipsLabel.text = @"导出完成";
        BOOL videoCompatible = UIVideoAtPathIsCompatibleWithSavedPhotosAlbum(outputPath);
        if (videoCompatible) {
            UISaveVideoAtPathToSavedPhotosAlbum(outputPath, self, @selector(video:didFinishSavingWithError:contextInfo:), nil);
        } else {
            NSLog(@"该视频无法保存至相册");
        }
        
    }];
}

- (void)video:(NSString *)videoPath didFinishSavingWithError:(NSError *)error contextInfo:(void *)contextInfo {
    if (error) {
        NSLog(@"保存视频到相册失败：%@", videoPath);
        
    } else {
        NSLog(@"保存视频到相册成功");
        self.tipsLabel.text = @"保存到相册";
    }
}

#pragma mark - TAVMediaPlayerObserver
- (void)mediaPlayerItemDidChange:(AVPlayerItem *)playerItem {
    CMTime duration = playerItem.duration;
    [self.controlController updateTotalDurationLabelWithTime:CMTimeGetSeconds(duration)];
}

- (void)mediaPlayerProgressDidChange:(CMTime)currentTime {
    [self.controlController updateNowDurationLabelWithTime:CMTimeGetSeconds(currentTime)];
}


- (void)mediaPlayerStateDidChange:(TAVPlaybackState)state {
    switch (state) {
        case TAVPlaybackStateLoading:
        case TAVPlaybackStatePlaying: {
            self.controlController.playButton.selected = YES;
        }
            break;
            
        case TAVPlaybackStatePaused:
        case TAVPlaybackStateStopped:
        case TAVPlaybackStateFinished: {
            self.controlController.playButton.selected = NO;
        }
            
        default:
            break;
    }
}

- (void)dealloc
{
    NSLog(@"%s",__func__);
//    [self.tavEditor destoryPlayer];
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self.tavEditor play];
}

- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    [self.tavEditor stop];
}

#pragma mark - tableview Datasource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.titles.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"Cell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier];
    }
    cell.textLabel.text = [NSString stringWithFormat:@"%@", self.titles[indexPath.row]];
    cell.textLabel.font = [UIFont systemFontOfSize:12];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSString *funcName = self.funcNames[indexPath.row];
    SEL sel = NSSelectorFromString(funcName);
    [self performSelector:sel];
}

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    self.tipsLabel.hidden = YES;
}

@end
