//
//  ViewController.m
//  PodTest
//
//  Created by chavezchen on 2024/6/26.
//

#import "ViewController.h"
#import <TAVMagic/TAVEditor.h>
#import <YTCommonXMagic/TELicenseCheck.h>
#import <MobileCoreServices/MobileCoreServices.h>
#import "TZImagePickerController/TZImagePickerController.h"
#import "TestPlayerViewController.h"
#import "Masonry/Masonry.h"

static NSString *kTELinceseUrl = @"";
static NSString *kTELinceseKey = @"";

@interface ViewController ()
@property (nonatomic, strong) TAVEditor *tavEditor;
@property (nonatomic, assign) NSInteger albumAssetListCount;
@property (nonatomic, strong) UILabel *tipsLabel;
//@property (nonatomic, strong) TestPlayerViewController *playerVC;
@property (nonatomic, copy) NSString *defaultSandBoxTmpDir;
@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"Home";
    [self setupUI];
    // 创建沙盒目录
    [self createDefaultSandBoxTmpDir];
    // 鉴权
    [TELicenseCheck setTELicense:kTELinceseUrl key:kTELinceseKey completion:^(NSInteger authresult, NSString * _Nonnull errorMsg) {
        NSLog(@"authResult : %zd  msg:%@",authresult,errorMsg);
        [self initEditorSDK]; // 创建sdk
    }];
}

- (void)setupUI {
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = CGRectMake(0, 300, self.view.frame.size.width, 100);
    button.backgroundColor = [UIColor grayColor];
    [button setTitle:@"开始创作" forState:UIControlStateNormal];
    [button addTarget:self action:@selector(buttonClick) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:button];
}

- (void)buttonClick {
    [self.tavEditor clearAll];
    [self.tavEditor flushImmediately];
    [self showTZImagePicker];
}

- (void)initEditorSDK {
    NSString *bundlePath = [[NSBundle mainBundle] pathForResource:@"LightCore" ofType:@"bundle"];
    self.tavEditor = [TAVEditor editorWithRenderSize:CGSizeZero assetsPath:bundlePath];
}

- (void)showTZImagePicker {
    TZImagePickerController *imagePickerVc = [[TZImagePickerController alloc] initWithMaxImagesCount:12 columnNumber:3 delegate:self pushPhotoPickerVc:YES];
    imagePickerVc.allowPickingMultipleVideo = YES;
    imagePickerVc.allowPickingImage = YES;
    imagePickerVc.allowPickingVideo = YES;
    imagePickerVc.showSelectedIndex = YES;
    
    __weak __typeof(self) weakSelf = self;
    [imagePickerVc setDidFinishPickingPhotosHandle:^(NSArray<UIImage *> *photos, NSArray *assets, BOOL isSelectOriginalPhoto) {
        [self showTips];
        self.albumAssetListCount = assets.count;
        dispatch_async(dispatch_get_global_queue(0, 0), ^{
            for (int i = 0; i < assets.count; i++) {
                PHAsset *asset = assets[i];
                if (asset.mediaType == PHAssetMediaTypeImage) {
                    NSString *imagePath = [self imageResourceWithPHAsset:asset];
                    int ret = [self.tavEditor addImageClip:imagePath duration:kCMTimeZero];
                    NSLog(@"editor add image clip ret : %d",ret);
                    self.albumAssetListCount--;
                    [self checkFinishConvertingToItemList];
                } else if (asset.mediaType == PHAssetMediaTypeVideo) {
                    NSString *videoPath = [self videoResourceWithPHAsset:asset];
                    int ret = [self.tavEditor addVideoClip:videoPath];
                    NSLog(@"editor add video clip ret : %d",ret);
                    self.albumAssetListCount--;
                    [self checkFinishConvertingToItemList];
                }
            }
        });
    }];
    imagePickerVc.modalPresentationStyle = UIModalPresentationFullScreen;
    [self presentViewController:imagePickerVc animated:YES completion:nil];
}

- (void)checkAlbumAuthorize:(void(^)(PHAuthorizationStatus status))handler {
    PHAuthorizationStatus status = [PHPhotoLibrary authorizationStatus];
    if (status == PHAuthorizationStatusNotDetermined) {
        [self requestAuthorize:handler];
    } else {
        handler(status);
    }
}

- (void)requestAuthorize:(void(^)(PHAuthorizationStatus status))handler {
    [PHPhotoLibrary requestAuthorization:^(PHAuthorizationStatus status) {
        dispatch_async(dispatch_get_main_queue(), ^{
            if (handler) {
                handler(status);
            }
        });
    }];
}


- (NSString *)videoResourceWithPHAsset:(PHAsset *)phAsset {
    __block AVURLAsset *urlAsset;
    dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
    PHVideoRequestOptions *options = [[PHVideoRequestOptions alloc] init];
    options.networkAccessAllowed = NO;
    [PHImageManager.defaultManager requestAVAssetForVideo:phAsset options:options resultHandler:^(AVAsset * _Nullable asset, AVAudioMix * _Nullable audioMix, NSDictionary * _Nullable info) {
        urlAsset = (AVURLAsset *)asset;
        dispatch_semaphore_signal(semaphore);
    }];
    dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
    NSString *fileNameWithoutExtension = [[urlAsset URL].path lastPathComponent] ;
    NSString *toPath = [self.defaultSandBoxTmpDir stringByAppendingPathComponent:fileNameWithoutExtension];
    [self copyFileFromPath:[urlAsset URL].path toPath:toPath];
    return toPath;
}

- (NSString *)imageResourceWithPHAsset:(PHAsset *)phAsset {
    PHAssetResource *imageResource = [PHAssetResource assetResourcesForAsset:phAsset].lastObject;
    NSURL *imageUrl = [imageResource valueForKey:@"privateFileURL"];
    NSString *originalFileName = imageResource.originalFilename;
    NSString *toPath = [self.defaultSandBoxTmpDir stringByAppendingPathComponent:originalFileName];
    [self copyFileFromPath:imageUrl.path toPath:toPath];
    return toPath;
}


- (void)checkFinishConvertingToItemList {
    // 全部转换完成
    NSLog(@"editor get clipCount %d",[self.tavEditor getClipCount]);
    if (self.albumAssetListCount == 0) {
        NSLog(@"----全部转换完成...");
        dispatch_async(dispatch_get_main_queue(), ^{
            [self hideTips];
            TestPlayerViewController *playerVC = [[TestPlayerViewController alloc] init];
            playerVC.tavEditor = self.tavEditor;
            [self.navigationController pushViewController:playerVC animated:YES];
        });
    }
}

#pragma mark - FileManager
- (BOOL)copyFileFromPath:(NSString *)fromPath toPath:(NSString *)toPath {
    if (![self fileExistsAtPath:fromPath]) return NO;
    BOOL remove = YES;
    if ([self fileExistsAtPath:toPath]) {
        remove = [self removeFileAtPath:toPath];
    }
    NSError *error = nil;
    BOOL copy = [[NSFileManager defaultManager] copyItemAtPath:fromPath toPath:toPath error:&error];
    return (remove && copy);
}

- (BOOL)fileExistsAtPath:(NSString *)filePath {
    BOOL isDirectory = NO;
    BOOL result = [[NSFileManager defaultManager] fileExistsAtPath:filePath isDirectory:&isDirectory];
    return result&!isDirectory;
}

- (BOOL)removeFileAtPath:(NSString *)path {
    if (![self fileExistsAtPath:path]) return NO;
    BOOL remove = [[NSFileManager defaultManager] removeItemAtPath:path error:NULL];
    return remove;
}

- (void)createDefaultSandBoxTmpDir {
    self.defaultSandBoxTmpDir = [[NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) firstObject] stringByAppendingPathComponent:@"MagicCut"];
    NSFileManager *fileManager = [NSFileManager defaultManager];
    if (![fileManager fileExistsAtPath:self.defaultSandBoxTmpDir]) {
        NSError *error = nil;
        [fileManager createDirectoryAtPath:self.defaultSandBoxTmpDir withIntermediateDirectories:YES attributes:nil error:&error];
        if (error) {
            NSLog(@"创建目录失败: %@", error.localizedDescription);
            return; // 处理错误
        }
    }
}

- (void)removeDefaultSandBoxTmpDir {
    if(self.defaultSandBoxTmpDir == nil) {
        return;
    }
    NSFileManager *fileManager = [NSFileManager defaultManager];
    NSURL *defaultSandBoxTmpDirURL = [NSURL fileURLWithPath:self.defaultSandBoxTmpDir];
    
    // 删除目录及其内容
    if ([fileManager fileExistsAtPath:self.defaultSandBoxTmpDir]) {
        NSError *error = nil;
        [fileManager removeItemAtURL:defaultSandBoxTmpDirURL error:&error];
        if (error) {
            NSLog(@"删除目录失败: %@", error.localizedDescription);
        } else {
            NSLog(@"删除目录成功");
        }
    }
}

//- (TestPlayerViewController *)playerVC
//{
//    if (!_playerVC) {
//        _playerVC = [[TestPlayerViewController alloc] init];
//    }
//    return _playerVC;
//}


- (void)showTips
{
    self.tipsLabel.hidden = NO;
    
}

- (void)hideTips
{
    self.tipsLabel.hidden = YES;
}

- (UILabel *)tipsLabel
{
    if (!_tipsLabel) {
        self.tipsLabel = [[UILabel alloc] init];
        self.tipsLabel.backgroundColor = [UIColor grayColor];
        self.tipsLabel.alpha = 0.9;
        [self.view addSubview:self.tipsLabel];
        [self.tipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.center.mas_equalTo(0);
        }];
        self.tipsLabel.hidden = YES;
        self.tipsLabel.text = @"视频转码中...";
        self.tipsLabel.textColor = [UIColor redColor];
    }
    return _tipsLabel;
}

@end
