#import "AppConfigManager.h"
#import <YTCommonXMagic/TELicenseCheck.h>
#import <TXLiteAVSDK_Professional/TXLiteAVSDK.h>
#import "AFNetworking/AFNetworking.h"


static NSString *kTELinceseUrl = @"";
static NSString *kTELinceseKey = @"";

NSNotificationName const TAVShortVideoLicenseSuccessNotification = @"TAVShortVideoLicenseSuccessNotification";
@interface AppConfigManager ()<TXLiveBaseDelegate>{
    BOOL _isSVLicenseValid;
    BOOL _isTELicenseValid;
}
@property (nonatomic, copy) ConfigCompletion liteAvCompletion;
@end

@implementation AppConfigManager

#pragma mark - Life Cycle
+ (instancetype)sharedManager {
    static dispatch_once_t predicate;
    static AppConfigManager *_sharedManager;
    dispatch_once(&predicate, ^{
        _sharedManager = [[AppConfigManager alloc] init];
    });
    return _sharedManager;
}

- (instancetype)init{
    self = [super init];
    if (self){
        _isSVLicenseValid = NO;
        _isTELicenseValid = NO;
        [self setupSeniorEditor];
        [self startNetWorkMonitor];
    }
    return self;
}

#pragma mark - Network
- (void)startNetWorkMonitor
{
    AFNetworkReachabilityManager *mgr=[AFNetworkReachabilityManager sharedManager];
    __weak __typeof(self)weakSelf = self;
    [mgr setReachabilityStatusChangeBlock:^(AFNetworkReachabilityStatus status) {
        if (status != AFNetworkReachabilityStatusNotReachable) {
            __strong typeof(self) strongSelf = weakSelf;
            dispatch_async(dispatch_get_main_queue(), ^{
                //主线程下周期执行
                [strongSelf setupSeniorEditor];
            });
        }
    }];
    //开始监控
    [mgr startMonitoring];
}

- (void)setupSeniorEditor {
    [self checkSVLicense];
    [self checkTELicense];
}

- (void)checkSVLicense{
    if (_isSVLicenseValid){
        return;
    }
    
    static NSInteger SVLicenseAgainNum = 5;
    if (SVLicenseAgainNum < 0){
        return;
    }
    SVLicenseAgainNum --;
    __weak __typeof(self)weakSelf = self;
    [self setShortVideoLicense:^(NSInteger authresult, NSString * _Nonnull errorMsg) {
        __strong typeof(self) strongSelf = weakSelf;
        NSLog(@"Short video license authresult:%ld, error:%@", (long)authresult, errorMsg);
        
        BOOL isAuthValid = (authresult == 0);
        strongSelf->_isSVLicenseValid = isAuthValid;
        [strongSelf stopMonitoringIfNeed];
        if (isAuthValid){
            SVLicenseAgainNum = 0;
            [[NSNotificationCenter defaultCenter] postNotificationName:TAVShortVideoLicenseSuccessNotification object:nil];
        } else {
            // 重新请求license
            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)((5 - SVLicenseAgainNum) * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                [strongSelf checkSVLicense];
            });
        }
    }];
}

- (void)checkTELicense{
    if (_isTELicenseValid){
        return;
    }
    static NSInteger TELicenseAgainNum = 5;
    if (TELicenseAgainNum < 0){
        return;
    }
    TELicenseAgainNum --;
    __weak __typeof(self)weakSelf = self;
    [self setTELicense:^(NSInteger authresult, NSString * _Nonnull errorMsg) {
        __strong typeof(self) strongSelf = weakSelf;
        NSLog(@"TELicense authresult:%ld, error:%@", (long)authresult, errorMsg);
        
        BOOL isAuthValid = (authresult == 0);
        strongSelf->_isTELicenseValid = isAuthValid;
        [strongSelf stopMonitoringIfNeed];
        if (isAuthValid){
            TELicenseAgainNum = 0;
        } else {
            // 重新请求license
            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)((5 - TELicenseAgainNum) * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                [strongSelf checkTELicense];
            });
        }
    }];
}

- (void)stopMonitoringIfNeed{
    if (_isSVLicenseValid && _isTELicenseValid) {
        [[AFNetworkReachabilityManager sharedManager] stopMonitoring];
    }
}

#pragma mark - Public API
static dispatch_once_t liteAvOnceToken;
- (void)setShortVideoLicense:(ConfigCompletion)completion {
    if (liteAvOnceToken) {
        completion(0, @"Success");
    }
    dispatch_once(&liteAvOnceToken, ^{
        NSString *licenceUrl = kTELinceseUrl;
        NSString *licenceKey = kTELinceseKey;
        [TXLiveBase setLicenceURL:licenceUrl key:licenceKey];
        [[TXLiveBase sharedInstance] setDelegate:self];
        self.liteAvCompletion = completion;
    });
}

- (void)setTELicense:(ConfigCompletion)completion {
    static dispatch_once_t onceToken;
    if (onceToken) {
        !completion ?: completion(0, @"Success");
    }
    dispatch_once(&onceToken, ^{
        [TELicenseCheck setTELicense:kTELinceseUrl
                                 key:kTELinceseKey
                          completion:^(NSInteger authresult, NSString * _Nonnull errorMsg) {
            NSLog(@"authResult : %zd  msg:%@",authresult,errorMsg);
            if (authresult != 0) {
                onceToken = 0x0;
            }
            !completion ?: completion(authresult, errorMsg);
        }];
    });
}

+ (NSString *)getLicenceInfo {
    return [TXLiveBase getLicenceInfo];
}

- (BOOL)isShortVideoLicenseValid{
    return _isSVLicenseValid;
}

///TXLiveBaseDelegate
- (void)onLicenceLoaded:(int)result Reason:(NSString *)reason {
    NSLog(@"vodLicenceLoaded:%d reason : %@",result, reason);
    if (result != 0) {
        liteAvOnceToken = 0x0;
    }
    dispatch_async(dispatch_get_main_queue(), ^{
        !self.liteAvCompletion ?: self.liteAvCompletion(result, reason);
        self.liteAvCompletion = nil;
    });
}

@end

