//
//  HomeShortVideoViewController.m
//  TAVMagicApp
//
//  Created by v_zwtzzhou on 2025/5/27.
//

#import "HomeShortVideoViewController.h"
#import <TUIPlayerShortVideo/TUIShortVideoView.h>
#import <Masonry/Masonry.h>
#import <Foundation/Foundation.h>
#import "AppConfigManager.h"
#import "AppConfigManager.h"

@interface HomeShortVideoViewController () <TUIShortVideoViewDelegate>
@property (nonatomic, strong) TUIShortVideoView *videoView;
@property (nonatomic, strong) UIButton *playBtn;
@end

@implementation HomeShortVideoViewController

- (void)viewDidLoad{
    [super viewDidLoad];
    if ([[AppConfigManager sharedManager] isShortVideoLicenseValid]){
        [self setupTUIPlayer];
    } else {
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(DidlicenseChanged:) name:TAVShortVideoLicenseSuccessNotification object:nil];
    }
  
    [self addPlayerControl];
}
- (void)viewDidDisappear:(BOOL)animated {
    [super viewDidDisappear:animated];
    [self.videoView pause];
}

- (void)viewDidAppear:(BOOL)animated{
    [super viewDidAppear:animated];
    [self.videoView resume];
}

- (void)setupTUIPlayer {
    self.videoView = [self makePlayer];
    [self.view addSubview:self.videoView];
    [self.view sendSubviewToBack:self.videoView];
    [self.videoView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.offset(0);
    }];
    
    [self.videoView addSubview:self.playBtn];
    [self.playBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(self.videoView.mas_centerX);
        make.centerY.mas_equalTo(self.videoView.mas_centerY);
        make.width.height.mas_equalTo(100);
    }];
    
    [self startLoading];
}

- (void)addPlayerControl{
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(viewOnTap:)];
    tap.numberOfTapsRequired = 1;
    tap.numberOfTouchesRequired = 1;
    [self.view addGestureRecognizer:tap];
}

- (void)DidlicenseChanged:(NSNotification *)notification{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:TAVShortVideoLicenseSuccessNotification object:nil];
    dispatch_async(dispatch_get_main_queue(), ^{
        if (!self.videoView){
            [self setupTUIPlayer];
        }
    });
    
}

#pragma mark - Player
- (void)startLoading {
    [self.videoView startLoading];
    [self.videoView setShortVideoModels:[self getVideo:@"video5"]];
}

- (TUIShortVideoView *)makePlayer {
    
    TUIPlayerShortVideoUIManager *uiManager = [[TUIPlayerShortVideoUIManager alloc] init];
    TUIShortVideoView *_videoView = [[TUIShortVideoView alloc] initWithUIManager:uiManager];
    _videoView.delegate = self;
    //_videoView.isAutoPlay = NO;
    
    // Set your playback strategy
    TUIPlayerVodStrategyModel *model = [[TUIPlayerVodStrategyModel alloc] init];
    model.mPreloadConcurrentCount = 2;
    model.preDownloadSize = 1;
    model.enableAutoBitrate = NO;
    model.isLastPrePlay = YES;
    
    ///rendMode
    
    model.mRenderMode = TUI_RENDER_MODE_FILL_EDGE;
    //model.mRenderMode = TUI_RENDER_MODE_FILL_SCREEN;
    [_videoView setShortVideoStrategyModel:model];
    
    // live strategy
    TUIPlayerLiveStrategyModel *liveStrateyModel = [[TUIPlayerLiveStrategyModel alloc] init];
    liveStrateyModel.isLastPrePlay = YES;
    
    [_videoView setShortVideoLiveStrategyModel:liveStrateyModel];
    
    return _videoView;
}

- (void)resume {
    [self.videoView resume];
}

- (void)pause {
    [self.videoView pause];
}

#pragma mark - Control
- (void)viewOnTap:(UITapGestureRecognizer *)tap{
    if ([self.videoView isPlaying]){
        [self.videoView pause];
    } else {
        [self.videoView resume];
    }
}

- (void)playClick {
    [self resume];
}

#pragma mark - TUIShortVideoViewDelegate
/**
 * 滑动回调
 * @param videoIndex 当前索引
 * @param videoModel 当前数据模型
 */
- (void)scrollToVideoIndex:(NSInteger )videoIndex
                videoModel:(TUIPlayerDataModel *)videoModel {
}

/**
 视频播放器状态
 @param videoModel 当前播放的视频数据模型
 @param status 播放状态
 */
- (void)currentVideo:(TUIPlayerVideoModel *)videoModel
       statusChanged:(TUITXVodPlayerStatus)status {
    
    self.playBtn.hidden = (status == TUITXVodPlayerStatusPlaying);
}

/**
 * 需要加载下一页
 * 回调时机跟TUIPlayerVodStrategyModel/mPreloadConcurrentCount相关
 * 例如：mPreloadConcurrentCount=3时, 此方法会在视频组的倒数第三个回调
 * 提醒加载新的一页数据
 */
- (void)onReachLast {
    [self.videoView appendShortVideoModels:[self getVideo:@"video4"]];
}

#pragma mark - UI
- (UIButton *)playBtn{
    if (!_playBtn) {
        _playBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_playBtn setImage:[UIImage imageNamed:@"feed_icon_display"] forState:UIControlStateNormal];
        _playBtn.frame = CGRectMake(0, 0, 100, 100);
        [_playBtn addTarget:self action:@selector(playClick) forControlEvents:UIControlEventTouchUpInside];
    }
    return _playBtn;
}

#pragma mark - DataSource
- (NSArray<TUIPlayerVideoModel *> *)getVideo:(NSString *)key {
    NSString *filePath = [[NSBundle mainBundle] pathForResource:@"TUIPlayer" ofType:@"plist"];
    NSDictionary *config = [[NSMutableDictionary alloc] initWithContentsOfFile:filePath];
    NSArray *dictArray = [config objectForKey:key];
    NSMutableArray *modelArray = [NSMutableArray array];
    
    NSArray *authors = @[@"Mercury", @"Venus", @"Earth", @"Mars", @"Jupiter", @"Saturn", @"Uranus", @"Neptune"];
    ///
    for ( NSUInteger i = 0; i < dictArray.count; i++) {
        NSDictionary *dict = dictArray[i];
        TUIPlayerVideoModel *model = [[TUIPlayerVideoModel alloc] init];
        model.videoUrl = dict[@"videoUrl"];
        model.coverPictureUrl = dict[@"coverPictureUrl"];
        model.duration = dict[@"duration"];
        model.appId = [(NSString *)dict[@"appId"] intValue];
        model.fileId = dict[@"fileId"];
        model.pSign = dict[@"pSign"];
        
        NSString *author = [authors objectAtIndex:arc4random_uniform((uint32_t)authors.count)];
        NSDictionary *extr = @{
            @"name":[@"@" stringByAppendingString:author],
            @"iconUrl":@"qq",
            @"title":[NSString stringWithFormat:@"This is %@\'s video introduction", author],
            @"topic":@"#This is a video topic",
            @"advertise":@"I am an advertisement please click me hahahaha",
            @"lickCount":@"1"
        };
        model.extInfo = extr;
        if (i == 0) { ///字幕测试
            TUIPlayerSubtitleModel *subTitleModel = [[TUIPlayerSubtitleModel alloc] init];
            subTitleModel.url = @"https://mediacloud-76607.gzc.vod.tencent-cloud.com/DemoResource/TED-CN.srt";
            subTitleModel.name = @"ex-cn-srt";
            subTitleModel.mimeType = 0;
            model.subtitles = @[subTitleModel];
        }
        TUIPlayerVideoConfig *config = [[TUIPlayerVideoConfig alloc] init];
        ///Determine whether your video is horizontal or vertical. This is just an example. The actual judgment conditions depend on your business.
//        if (i == 0 || i == 2) {
//            config.renderMode = TUI_RENDER_MODE_FILL_SCREEN;
//        } else {
//            config.renderMode = TUI_RENDER_MODE_FILL_EDGE;
//        }
        model.config = config;
        [modelArray addObject:model];
    }
    return modelArray;
}

@end
