//
//  HomeCreationView.m
//  TAVMagicApp
//
//  Created by v_zwtzzhou on 2025/4/1.
//

#import "HomeCreationView.h"
#import <TAVMagicUIKit/UIColor+TAVUtil.h>

@import Masonry;

@interface HomeCreationView()
@property (nonatomic, readwrite) UILabel *titleLabel;
@property (nonatomic, readwrite) UIButton *closeButton;
@property (nonatomic, readwrite) UIButton *videoShootButton;
@property (nonatomic, readwrite) UIButton *videoEditButton;
@property (nonatomic, readwrite) UIButton *makeSameButton;
@property (nonatomic, readwrite) UIButton *draftBoxButton;

@property (nonatomic, weak) UILabel *videoShootTitleLabel;
@property (nonatomic, weak) UILabel *videoShootSubTitleLabel;
@property (nonatomic, weak) UILabel *videoEditTitleLabel;
@property (nonatomic, weak) UILabel *videoEditSubTitleLabel;
@property (nonatomic, weak) UILabel *makeSameTitleLabel;
@property (nonatomic, weak) UILabel *makeSameSubTitleLabel;


@end

@implementation HomeCreationView

- (instancetype)init{
    self = [super init];
    if (self){
        [self setUI];
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setUI];
    }
    return self;
}

- (instancetype)initWithCoder:(NSCoder *)coder
{
    self = [super initWithCoder:coder];
    if (self) {
        [self setUI];
    }
    return self;
}

- (void)setUI{
    self.layer.cornerRadius = 16.0;
    self.layer.masksToBounds = YES;
    self.backgroundColor = [UIColor tvc_colorWithHexString:@"#1f2024"];
    [self addGestureRecognizer:[UITapGestureRecognizer new]];
    
    /// top:
    self.titleLabel = [self customTitleLabel];
    [self addSubview:self.titleLabel];
    self.closeButton = [self customCloseButton];
    [self addSubview:self.closeButton];
    
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.offset(0);
        make.width.equalTo(self.mas_width);
        make.height.mas_equalTo(24);
        make.top.offset(20);
    }];
    
    [self.closeButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(34);
        make.top.offset(15);
        make.right.offset(-11);
    }];
    
    /// button
    self.videoShootButton = [self customEntryButton];
    [self.videoShootButton setImage:[UIImage imageNamed:@"tools_video_shoot"] forState:UIControlStateNormal];
    [self addSubview:self.videoShootButton];
    [self.videoShootButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(68);
        make.left.offset(48);
        make.width.height.mas_equalTo(48);
    }];
    
    self.videoEditButton = [self customEntryButton];
    [self.videoEditButton setImage:[UIImage imageNamed:@"tools_video_eidt"] forState:UIControlStateNormal];
    [self addSubview:self.videoEditButton];
    [self.videoEditButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.videoShootButton.mas_top);
        make.centerX.equalTo(self.mas_centerX);
        make.width.height.mas_equalTo(48);
    }];
    
    self.makeSameButton = [self customEntryButton];
    [self.makeSameButton setImage:[UIImage imageNamed:@"tools_make_same"] forState:UIControlStateNormal];
    [self addSubview:self.makeSameButton];
    [self.makeSameButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.videoShootButton.mas_top);
        make.right.offset(-48);
        make.width.height.mas_equalTo(48);
    }];
    
    /// title
    UILabel *videoShootTitleLabel = [self buttonTitleLable];
    videoShootTitleLabel.text = NSLocalizedString(@"Home.Creation.Video Recorder", "视频拍摄");
    [self addSubview:videoShootTitleLabel];
    self.videoShootTitleLabel = videoShootTitleLabel;
    self.videoShootTitleLabel.text = NSLocalizedString(@"Home.Creation.Video Recorder", "视频拍摄");
    UILabel *videoShootSubTitleLabel = [self buttonSubTitleLabel];
    videoShootSubTitleLabel.text = NSLocalizedString(@"Home.Creation.Built-in Beauty", "自带美颜特效");

    [self addSubview:videoShootSubTitleLabel];
    self.videoShootSubTitleLabel = videoShootSubTitleLabel;
    self.videoShootSubTitleLabel.text = NSLocalizedString(@"Home.Creation.Built-in Beauty", "自带美颜特效");
    UILabel *videoEditTitleLabel = [self buttonTitleLable];
    videoEditTitleLabel.text = NSLocalizedString(@"Home.Creation.Video Editor", "视频编辑");

    [self addSubview:videoEditTitleLabel];
    self.videoEditTitleLabel = videoEditTitleLabel;
    self.videoEditTitleLabel.text = NSLocalizedString(@"Home.Creation.Video Editor", "视频编辑");
    UILabel *videoEditSubTitleLabel = [self buttonSubTitleLabel];
    [self addSubview:videoEditSubTitleLabel];
    self.videoEditSubTitleLabel = videoEditSubTitleLabel;
    self.videoEditSubTitleLabel.text = NSLocalizedString(@"Home.Creation.Video Precise Cut", "导入视频 精确裁剪");
    UILabel *makeSameTitleLabel = [self buttonTitleLable];
    makeSameTitleLabel.text = NSLocalizedString(@"Home.Creation.Template", "剪同款");
    [self addSubview:makeSameTitleLabel];
    self.makeSameTitleLabel = makeSameTitleLabel;
    self.makeSameTitleLabel.text = NSLocalizedString(@"Home.Creation.Template", "剪同款");
    UILabel *makeSameSubTitleLabel = [self buttonSubTitleLabel];
    makeSameSubTitleLabel.text = NSLocalizedString(@"Home.Creation.Video AutoCut", "参考模版快速出片");

    [self addSubview:makeSameSubTitleLabel];
    self.makeSameSubTitleLabel = makeSameSubTitleLabel;
    self.makeSameSubTitleLabel.text = NSLocalizedString(@"Home.Creation.Video AutoCut", "参考模版快速出片");
    void(^alignmentButtonLabelBlock)(UIButton *, UILabel *, UILabel *) = ^(UIButton *button, UILabel *titleLabel, UILabel *subTitleLabel){
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(button.mas_bottom).offset(8);
            make.centerX.equalTo(button.mas_centerX);
            make.width.mas_equalTo(100);
            make.height.mas_equalTo(22);
        }];
        [subTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(titleLabel.mas_bottom).offset(2);
            make.centerX.equalTo(button.mas_centerX);
            make.width.mas_equalTo(100);
            make.height.mas_equalTo(14);
        }];
    };
    
    alignmentButtonLabelBlock(self.videoShootButton, videoShootTitleLabel, videoShootSubTitleLabel);
    alignmentButtonLabelBlock(self.videoEditButton, videoEditTitleLabel, videoEditSubTitleLabel);
    alignmentButtonLabelBlock(self.makeSameButton, makeSameTitleLabel, makeSameSubTitleLabel);
    
    /// bottom
    UIView *line = [self lineView];
    [self addSubview:line];
    [line mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(20);
        make.right.offset(-20);
        make.height.mas_equalTo(1);
        make.top.offset(184);
    }];
    
    self.draftBoxButton = [self customDraftBoxButton];
    [self addSubview:self.draftBoxButton];
    [self.draftBoxButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(184);
        make.left.mas_equalTo(20);
        make.height.mas_equalTo(64);
        make.centerX.mas_equalTo(self.mas_centerX);
    }];
}
# pragma mark - Custom View
- (UILabel *)customTitleLabel {
    UILabel *titleLabel = [[UILabel alloc] initWithFrame:CGRectZero];
    titleLabel.textColor = [UIColor tvc_colorWithHexString:@"#FFFFFF"];
    titleLabel.font = [UIFont systemFontOfSize:16];
    titleLabel.text = NSLocalizedString(@"Home.Creation.Introduce", "短视频创作功能");
    titleLabel.textAlignment = NSTextAlignmentCenter;
    return titleLabel;
}

- (UIButton *)customCloseButton {
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setImage:[UIImage imageNamed:@"tools_close"] forState:UIControlStateNormal];
    return btn;
}

- (UIButton *)customEntryButton{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    return btn;
}

- (UILabel *)buttonTitleLable{
    UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 22)];
    label.textColor = [UIColor tvc_colorWithHexString:@"#FFFFFF"];
    label.font = [UIFont systemFontOfSize:16];
    label.textAlignment = NSTextAlignmentCenter;
    label.adjustsFontSizeToFitWidth = YES;
    label.userInteractionEnabled = NO;
    return label;
}

- (UILabel *)buttonSubTitleLabel{
    UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 14)];
    label.textColor = [UIColor tvc_colorWithHexString:@"#FFFFFF8C"];
    label.font = [UIFont systemFontOfSize:10];
    label.textAlignment = NSTextAlignmentCenter;
    label.adjustsFontSizeToFitWidth = YES;
    label.userInteractionEnabled = NO;
    return label;
}

- (UIView *)lineView{
    UIView *line = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 10, 1)];
    line.backgroundColor = [UIColor tvc_colorWithHexString:@"#FFFFFF8C"];
    return line;
}

- (UIButton *)customDraftBoxButton{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setTitle:NSLocalizedString(@"Home.Creation.Drafts", "草稿箱") forState:UIControlStateNormal];
    [btn setImage:[UIImage imageNamed:@"tools_folder_open"] forState:UIControlStateNormal];
    [btn setImageEdgeInsets:UIEdgeInsetsMake(0, 0, 0, 10)];
    return btn;
}

@end
