//
//  HomeInfoView.m
//  TAVMagicApp
//
//  Created by v_zwtzzhou on 2025/4/14.
//

#import "HomeInfoView.h"
#import "TAVMagicUIKit/UIColor+TAVUtil.h"

@import Masonry;
@interface HomeInfoView ()

@property (nonatomic, readwrite) UILabel *titleLabel;
@property (nonatomic, readwrite) UILabel *subTitleLabel;
@property (nonatomic, readwrite) UIButton *creationButton;

@property (nonatomic, strong) CAGradientLayer *gradientLayer;
@end

@implementation HomeInfoView

- (instancetype)init{
    self = [super init];
    if (self){
        [self setUI];
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setUI];
    }
    return self;
}

- (instancetype)initWithCoder:(NSCoder *)coder
{
    self = [super initWithCoder:coder];
    if (self) {
        [self setUI];
    }
    return self;
}

- (void)setUI{
    self.backgroundColor = [UIColor clearColor];
//    self.backgroundColor = [UIColor tvc_colorWithHexString:@"#1f2024"];
    
    self.titleLabel = [self customTitleLabel];
    [self addSubview:self.titleLabel];
    
    self.subTitleLabel = [self customSubTitleLabel];
    [self addSubview:self.subTitleLabel];
    
    self.creationButton = [self customCreationButton];
    [self addSubview:self.creationButton];
    
    [self.creationButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(48);
        make.width.mas_equalTo(128);
        make.top.offset(45);
        make.right.offset(-16);
    }];
    
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(16);
        make.right.offset(-179);
        make.height.mas_equalTo(26);
        make.bottom.equalTo(self.subTitleLabel.mas_top).offset(-4);
    }];
    
    [self addGradientColor];
}

- (void)addGradientColor{
    CAGradientLayer *gradientLayer = [CAGradientLayer layer];
    
    // 设置渐变颜色
    UIColor *color1 = [UIColor tvc_colorWithHexString:@"#0F101400"];
    UIColor *color2 = [UIColor tvc_colorWithHexString:@"#0F101499"];
    gradientLayer.colors = @[(id)color1.CGColor, (id)color2.CGColor];
    
    // 设置渐变的起始点和结束点，这里表示从顶部到底部的渐变
    gradientLayer.startPoint = CGPointMake(0.5, 0);
    gradientLayer.endPoint = CGPointMake(0.5, 1);
    
    // 设置渐变图层的大小与视图的大小一致
    gradientLayer.frame = self.bounds;
    
    // 将渐变图层添加到视图的图层上
    [self.layer insertSublayer:gradientLayer atIndex:0];
    self.gradientLayer = gradientLayer;
}

#pragma mark - Public
- (void)layoutSubviews{
    self.gradientLayer.frame = self.bounds;

    CGRect bounds = self.bounds;
    CGRect textBounds = CGRectMake(0, 0, bounds.size.width - 16 - 170, self.subTitleLabel.font.lineHeight * 3);
    CGRect rect = [self.subTitleLabel textRectForBounds:textBounds limitedToNumberOfLines:2];
    self.subTitleLabel.frame = CGRectMake(16, bounds.size.height - 50 - rect.size.height, rect.size.width, rect.size.height);
}

# pragma mark - Custom View
- (UILabel *)customTitleLabel{
    UILabel *label = [[UILabel alloc] initWithFrame:CGRectZero];
    label.textColor = [UIColor tvc_colorWithHexString:@"#FFFFFF"];
    label.font = [UIFont systemFontOfSize:18];
    return label;
}

- (UILabel *)customSubTitleLabel{
    UILabel *label = [[UILabel alloc] initWithFrame:CGRectZero];
    label.textColor = [UIColor tvc_colorWithHexString:@"#FFFFFF"];
    label.font = [UIFont systemFontOfSize:12];
    label.numberOfLines = 0;
    return label;
}

- (UIButton *)customCreationButton{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.backgroundColor = [UIColor tvc_colorWithHexString:@"#FF6500"];
    btn.layer.cornerRadius = 24.0f;
    btn.layer.masksToBounds = YES;
    btn.titleLabel.font = [UIFont systemFontOfSize:16];
    btn.titleLabel.adjustsFontSizeToFitWidth = YES;
//    [btn setTitle:@"创作" forState:UIControlStateNormal];
    [btn setTitleColor:[UIColor tvc_colorWithHexString:@"#FFFFFF"] forState:UIControlStateNormal];
    [btn setTitleColor:[UIColor tvc_colorWithHexString:@"#D5E0F2"] forState:UIControlStateNormal];
    [btn setImage:[UIImage imageNamed:@"icon_creation"] forState:UIControlStateNormal];
    [btn setImageEdgeInsets:UIEdgeInsetsMake(0, 0, 0, 5)];
    return btn;
}

@end
