//
//  TAVPublishController.m
//  TAVMagicApp
//
//  Created by penghuixu on 2025/2/5.
//

#import "TAVPublishController.h"
#import "TAVPublishNavView.h"
#import "TAVPublishEditBoxView.h"
#import "TAVPublishBottomButtonBoxView.h"
#import <TAVMagicUIKit/TAVCoverSelectorController.h>
//#import "ITAVDraftManager.h"
#import <TAVMagic/ITAVDraftManager.h>
#import <TAVMagicUIKit/TAVTextToastView.h>
@import Masonry;

@interface TAVPublishController () <TAVCoverSelectorControllerDelegate>
@property (nonatomic, strong) TAVPublishNavView *navView;
@property (nonatomic, strong) TAVPublishEditBoxView *editBox;
@property (nonatomic, strong) TAVPublishBottomButtonBoxView *buttonBox;
@property (nonatomic, copy) NSString *exportEditorKey;
@property (nonatomic, weak) TAVEditor *exportEditor;
@property (nonatomic, copy) NSString *coverEditorKey;
@property (nonatomic, weak) TAVEditor *coverEditor;
@property (nonatomic, weak) TAVEditor *draftEditor;
@property (nonatomic, assign) CMTime lastCoverImgSelectedPostion;
@property (nonatomic, strong) TAVCoverSelectorController *coverSelectorController;



@end

@implementation TAVPublishController

- (instancetype)initWithEditor:(TAVEditor *)editor {
    self = [super init];
    if (self) {
        _draftEditor = editor;
        _exportEditorKey = [TAVEditorManager.sharedManager fork:editor];
        _exportEditor = [TAVEditorManager.sharedManager getEditorForKey:_exportEditorKey];
        _coverEditorKey = [TAVEditorManager.sharedManager fork:editor];
        _coverEditor = [TAVEditorManager.sharedManager getEditorForKey:_coverEditorKey];
        _lastCoverImgSelectedPostion = kCMTimeZero;
    }
    return self;
}

- (void)dealloc
{
    [TAVEditorManager.sharedManager removeAllEditors];
}

- (void)viewDidLoad{
    [super viewDidLoad];
    [self setupUI];
    [self setupActions];
}

- (void)setupUI {
    self.view.backgroundColor = UIColor.whiteColor;

    [self.view addSubview:self.navView];
    [self.navView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.offset(0);
        make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop);
        make.height.offset(44);
    }];
    
    [self.view addSubview:self.buttonBox];
    [self.buttonBox mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.view.mas_safeAreaLayoutGuideBottom).offset(-36);
        make.width.equalTo(self.view);
        make.height.offset(50); // 高度覆盖按钮
    }];
    [self.view addSubview:self.editBox];
    [self.editBox mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.navView.mas_bottom);
        make.left.right.offset(0);
        make.height.offset(163);
    }];

}

- (void)setupActions {
    [self.buttonBox.postBtn addTarget:self action:@selector(handlePostBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [self.buttonBox.draftsBtn addTarget:self action:@selector(handleDraftsBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [self.editBox.coverEditBtn addTarget:self action:@selector(handleCoverEditBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [self.navView.backBtn addTarget:self action:@selector(backAction:) forControlEvents:UIControlEventTouchUpInside];
}
#pragma mark - dismisskeyboard
- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    [super touchesBegan:touches withEvent:event];
    [self.view endEditing:YES]; // 收起键盘
}


- (void)handlePostBtnClick:(UIButton *)sender {
    __weak __typeof(self)weakSelf = self;
    [self generateVideoWithCompletion:^{
        [weakSelf goBackToHomePage];
    }];
}
- (void)handleDraftsBtnClick:(UIButton *)sender {
    id<ITAVDraftManager> m = [self.draftEditor getDraftManager];
    if(!m) {
        NSLog(@"getDraftManager failed");
        return;
    }
    NSString *thumbnailPath = [self saveSelectedThumbnail];
    if(!thumbnailPath) {
        NSLog(@"save thumbnail failed");
        return;
    }
    TAVDraft *draft = [m getCurrentDraft];
    [draft setThumbnail:thumbnailPath];
    BOOL t = [m generateDraft];
    if(!t) {
        NSLog(@"generateDraft failed");
        return;
    }
    [self goBackToHomePage];
    [TAVTextToastView showToast:NSLocalizedString(@"Draft.saved", "草稿保存完毕") duration:2];
}

// 前往首页
- (void)goBackToHomePage {
    [self.navigationController popToRootViewControllerAnimated:YES];
}
    

- (void)handleCoverEditBtnClick:(UIButton *)sender {
    if(!self.coverSelectorController) {
        TAVCoverSelectorController *coverSelectorController = [[TAVCoverSelectorController alloc] initWithEditor:self.draftEditor];
        coverSelectorController.delegate = self;
        [coverSelectorController selectCoverImgAtPosition:self.lastCoverImgSelectedPostion];
        _coverSelectorController = coverSelectorController;
    }
    [self.navigationController pushViewController:self.coverSelectorController animated:YES];
}

#pragma mark TAVCoverSelectorControllerDelegate
- (void)onSelectedCoverImg:(nonnull UIImage *)img atPosition:(CMTime)position {
    [self.editBox setCoverImg:img];
    self.lastCoverImgSelectedPostion = position;
}

#pragma mark utils
- (void)generateVideoWithCompletion: (void (^)(void))completion {
    NSString *tempDir = NSTemporaryDirectory();
    NSString *appLib = [tempDir stringByAppendingString:@"/Caches"];
    NSString *resDir = [appLib stringByAppendingPathComponent:@"tavXmagic"];
    if (!self.exportEditor) {
        [TAVTextToastView showToast:@"exportEditor faild" duration:1.0];
    }
    // 暂停视频播放
    [self.exportEditor pause];
    [TAVTextToastView showToast:NSLocalizedString(@"Generating.video","视频生成中") duration:0.5];
    TAVEditorGenerateConfig *config = [TAVEditorGenerateConfig new];
    config.videoConfig.exportTimeRange = CMTimeRangeMake(kCMTimeZero, CMTimeMakeWithSeconds(600, 600));
    [self.exportEditor quickGenerateVideo:config outputPath:resDir progress:^(CGFloat progress) {
        NSLog(@"progress : %f",progress);
        NSString *formatString = NSLocalizedString(@"Generating.video.progress", @"视频生成进度格式");
        NSString *progressText = [NSString stringWithFormat:formatString, progress * 100];
        [TAVTextToastView showToast:progressText duration:0.01];
        
    } completion:^(NSError * _Nonnull error, NSString * _Nonnull outputPath) {
        if (error) {
            NSLog(@"generateVideo error : %@",error);
            return;
        }
        BOOL videoCompatible = UIVideoAtPathIsCompatibleWithSavedPhotosAlbum(outputPath);
        if (videoCompatible) {
            UISaveVideoAtPathToSavedPhotosAlbum(outputPath, self, @selector(video:didFinishSavingWithError:contextInfo:), nil);
        } else {
            NSLog(@"该视频无法保存至相册");
        }
        if(completion) {
            completion();
        }
        
    }];
    
}

- (void)video:(NSString *)videoPath didFinishSavingWithError:(NSError *)error contextInfo:(void *)contextInfo {
    // 保存相册后删除缓存
    [[NSFileManager defaultManager] removeItemAtPath:videoPath error:nil];
    if (error) {
        NSLog(@"保存视频到相册失败：%@", videoPath);
        NSString *errorMsg = NSLocalizedString(@"Failed.to.save.video","保存视频到相册失败");
                [TAVTextToastView showToast:errorMsg duration:2];
    } else {
        NSLog(@"保存视频到相册成功");
        NSString *successMsg = NSLocalizedString(@"Video.saved.successfully","保存视频到相册成功");
        [TAVTextToastView showToast:successMsg duration:2];
    }
}

- (NSString *)saveSelectedThumbnail {
    UIImage* selectedThumbnail = self.editBox.coverImg;
    if (!selectedThumbnail) {
        return nil;
    }
    NSString *tempDir = NSTemporaryDirectory();
    // 随机生成文件名
    NSString *thumbnailPath = [tempDir stringByAppendingPathComponent:[NSString stringWithFormat:@"thumbnail_%@.jpg", [NSUUID UUID].UUIDString]];
    NSData *thumbnailData = UIImageJPEGRepresentation(selectedThumbnail, 1);
    [thumbnailData writeToFile:thumbnailPath atomically:YES];
    return thumbnailPath;
}

- (void)backAction:(UIButton *)btn {
    [self.exportEditor cancelGenerate:nil];
    if (self.navigationController) {
        [self.navigationController popViewControllerAnimated:YES];
    } else {
        [self dismissViewControllerAnimated:YES completion:nil];
    }
}


#pragma mark - lazy
- (TAVPublishNavView *)navView {
    if (!_navView) {
        _navView = [[TAVPublishNavView alloc] initWithTitle:NSLocalizedString(@"Post","发布") sender:self];
    }
    return _navView;
}

- (TAVPublishEditBoxView *)editBox {
    if (!_editBox) {
        _editBox = [[TAVPublishEditBoxView alloc] initWithEditor:self.coverEditor];
    }
    return _editBox;
}

- (TAVPublishBottomButtonBoxView *)buttonBox {
    if(!_buttonBox) {
        _buttonBox = [TAVPublishBottomButtonBoxView new];
    }
    return _buttonBox;
}
@end
