//
//  TAVActionSheetBaseView.m
//  TAVMagicApp
//
//  Created by jasonggao on 2025/6/3.
//

#import "TAVActionSheetBaseView.h"
#import <TAVMagicUIKit/UIColor+TAVUtil.h>

@interface TAVActionSheetBaseView ()
@property (nonatomic, strong, readwrite) UILabel *titleLabel; //标题
@property (nonatomic, strong, readwrite) UIButton *leftButton; //左侧按钮
@property (nonatomic, strong, readwrite) UIButton *rightButton; //右侧按钮
@end

@implementation TAVActionSheetBaseView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        
        [self initSubViews];
    }
    return self;
}

- (void)initSubViews {
    self.backgroundColor = [UIColor tvc_colorWithHexString:@"#1F2024"];
    self.layer.cornerRadius = 20;
    self.layer.maskedCorners = kCALayerMinXMinYCorner | kCALayerMaxXMinYCorner;
    
    self.titleLabel = [[UILabel alloc] init];
    self.titleLabel.text = @"标题";
    self.titleLabel.textColor = [UIColor whiteColor];
    self.titleLabel.textAlignment = NSTextAlignmentCenter;
    self.titleLabel.font = [UIFont systemFontOfSize:16];
    [self addSubview:self.titleLabel];
    
    self.leftButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.leftButton setTitle:@"取消" forState:UIControlStateNormal];
    [self.leftButton setTitleColor:[UIColor tvc_colorWithHexString:@"#FF6500"] forState:UIControlStateNormal];
    self.leftButton.titleLabel.font = [UIFont systemFontOfSize:16];
    self.leftButton.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
    [self addSubview:self.leftButton];
    
    self.rightButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.rightButton setTitle:@"完成" forState:UIControlStateNormal];
    [self.rightButton setTitleColor:[UIColor tvc_colorWithHexString:@"#FF6500"] forState:UIControlStateNormal];
    self.rightButton.titleLabel.font = [UIFont systemFontOfSize:16];
    self.rightButton.contentHorizontalAlignment = UIControlContentHorizontalAlignmentRight;
    [self addSubview:self.rightButton];
}

- (void)layoutSubviews {
    [super layoutSubviews];
    CGSize selfSize = self.bounds.size;
    self.titleLabel.frame = CGRectMake((selfSize.width - 150) / 2, 20, 150, 24);
    self.leftButton.frame = CGRectMake(16, 20, 40, 24);
    self.rightButton.frame = CGRectMake(selfSize.width - 56, 20, 40, 24);
}

- (void)showActionSheet {
    UIEdgeInsets safeAreaInsets = self.safeAreaInsets;
    self.transform = CGAffineTransformMakeTranslation(0, self.bounds.size.height + safeAreaInsets.bottom);
    [UIView animateWithDuration:0.15 delay:0 options:UIViewAnimationOptionCurveEaseInOut animations:^{
        self.transform = CGAffineTransformIdentity;
    } completion:nil];
}

- (void)hideActionSheet {
    [UIView animateWithDuration:0.15 animations:^{
        self.transform = CGAffineTransformMakeTranslation(0,self.frame.size.height);
    } completion:^(BOOL finished) {
        [self removeFromSuperview];
    }];
}

@end
