//
//  TAVPublishBottomButtonBoxView.m
//  TAVMagicApp
//
//  Created by penghuixu on 2025/2/6.
//

#import "TAVPublishBottomButtonBoxView.h"
@import Masonry;

@interface TAVPublishBottomButtonBoxView ()
@property (nonatomic, strong) UIButton *draftsBtn;
@property (nonatomic, strong) UIButton *postBtn;

@end


@implementation TAVPublishBottomButtonBoxView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self addSubview:self.draftsBtn];
        [self.draftsBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.offset(0);
            make.left.offset(15);
            make.width.offset(167);
            make.height.offset(48);
        }];
        
        
        [self addSubview:self.postBtn];
        [self.postBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.offset(0);
            make.right.offset(-15);
            make.width.offset(167);
            make.height.offset(48);
        }];
    }
    return self;
}

- (UIButton *)draftsBtn {
    if(!_draftsBtn) {
        _draftsBtn = [UIButton buttonWithType:UIButtonTypeSystem];
        _draftsBtn.layer.cornerRadius = 24;
        [_draftsBtn setTitle:NSLocalizedString(@"Drafts","草稿") forState:UIControlStateNormal];
        [_draftsBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        _draftsBtn.titleLabel.font = [UIFont boldSystemFontOfSize:15];

        _draftsBtn.backgroundColor = [UIColor clearColor];
        _draftsBtn.tintColor = [UIColor blackColor];

        _draftsBtn.layer.borderColor = [UIColor lightGrayColor].CGColor;
        _draftsBtn.layer.borderWidth = 1.0;
        // 添加图标
        [_draftsBtn setImage:[UIImage imageNamed:@"icon_publish_draft"] forState:UIControlStateNormal]; // 设置按钮图标
        [_draftsBtn setImageEdgeInsets:UIEdgeInsetsMake(0, -5, 0, 0)]; // 调整图标位置
        [_draftsBtn setTitleEdgeInsets:UIEdgeInsetsMake(0, 5, 0, 0)]; // 调整文字位置

    }
    return _draftsBtn;
}

- (UIButton *)postBtn {
    if(!_postBtn) {
        _postBtn = [UIButton buttonWithType:UIButtonTypeSystem];
        _postBtn.layer.cornerRadius = 24;
        [_postBtn setTitle:NSLocalizedString(@"Post","发布") forState:UIControlStateNormal];
        [_postBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        _postBtn.titleLabel.font = [UIFont boldSystemFontOfSize:15];
        _postBtn.backgroundColor = [UIColor orangeColor];
        _postBtn.tintColor = [UIColor whiteColor];

        // 添加图标
        UIImage *postIcon = [UIImage imageNamed:@"icon_publish_submit"];
        [_postBtn setImage:postIcon forState:UIControlStateNormal]; // 设置按钮图标
        [_postBtn setImageEdgeInsets:UIEdgeInsetsMake(0, -5, 0, 0)]; // 调整图标位置
        [_postBtn setTitleEdgeInsets:UIEdgeInsetsMake(0, 5, 0, 0)]; // 调整文字位置

    }
    return _postBtn;
}
@end
