//
//  TAVPublishEditBoxView.m
//  TAVMagicApp
//
//  Created by penghuixu on 2025/2/5.
//

#import "TAVPublishEditBoxView.h"
#import "TAVPublishEditCoverBoxView.h"
#import "TAVPublishEditDescribeBoxView.h"
@import Masonry;

@interface TAVPublishEditBoxView ()
@property (nonatomic, weak) TAVEditor *editor;
@property (nonatomic, strong) TAVPublishEditCoverBoxView *editCoverBoxView;
@property (nonatomic, strong) TAVPublishEditDescribeBoxView *editDescribeBoxView;

@end


@implementation TAVPublishEditBoxView

- (instancetype)initWithEditor:(TAVEditor *)editor {
    self = [self initWithFrame:CGRectZero withEditor:editor];
    if (self) {
    }
    return self;
}
- (instancetype)initWithFrame:(CGRect)frame withEditor:(TAVEditor *)editor {
    self = [super initWithFrame:frame];
    if (self) {
        self.editor = editor;
        [self addSubview:self.editCoverBoxView];
        [self.editCoverBoxView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.bottom.offset(-15);
            make.top.offset(15);
            make.width.offset(99);
        }];
        
        [self addSubview:self.editDescribeBoxView];
        [self.editDescribeBoxView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(15);
            make.right.equalTo(self.editCoverBoxView.mas_left).offset(-10);
            make.top.offset(15);
            make.bottom.offset(-15);
        }];
        
    }
    return self;
}


- (TAVPublishEditCoverBoxView *)editCoverBoxView {
    if (!_editCoverBoxView) {
        _editCoverBoxView = [[TAVPublishEditCoverBoxView alloc] initWithEditor:self.editor];
    }
    return _editCoverBoxView;
}

- (TAVPublishEditDescribeBoxView *)editDescribeBoxView {
    if (!_editDescribeBoxView) {
        _editDescribeBoxView = [TAVPublishEditDescribeBoxView new];
    }
    return _editDescribeBoxView;
}

#pragma mark Public
- (NSString *)text {
    return self.editDescribeBoxView.textView.text;
}

- (UIImage *)coverImg {
    return self.editCoverBoxView.imgView.image;
}

- (void)setCoverImg:(UIImage *)coverImg {
    [self.editCoverBoxView.imgView setImage:coverImg];
}

- (UIButton *)coverEditBtn {
    return self.editCoverBoxView.coverEditBtn;
}

@end
