//
//  TAVPublishEditCoverBoxView.m
//  TAVMagicApp
//
//  Created by penghuixu on 2025/2/5.
//

#import "TAVPublishEditCoverBoxView.h"
#import <TAVMagic/ITAVFrameProvider.h>
@import Masonry;

@interface TAVPublishEditCoverBoxView ()
@property (nonatomic, weak) TAVEditor *editor;
@property (nonatomic, strong) UIButton *coverEditBtn;
@property (nonatomic, strong) UIImageView *imgView;

@end

@implementation TAVPublishEditCoverBoxView
- (instancetype)initWithEditor:(TAVEditor *)editor {
    self = [self initWithFrame:CGRectZero withEditor:editor];
    if (self) {
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame withEditor:(TAVEditor *)editor {
    self = [super initWithFrame:frame];
    if (self) {
        self.editor = editor;

        self.layer.cornerRadius = 4.0;
        self.clipsToBounds = YES;
        
        [self addSubview:self.imgView];
        [self.imgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.width.equalTo(self);
            make.height.equalTo(self);
        }];
        
        
        [self addSubview:self.coverEditBtn];
        [self.coverEditBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.equalTo(self);
            make.height.offset(24);
            make.width.equalTo(self);
        }];

    }
    return self;
}

- (UIImageView *)imgView {
    if (!_imgView) {
        // 默认获取第一个作为封面，分辨率是设计稿的尺寸
        UIImage *img = [self.editor.getVideoFrameManager getClipFrameAtTime:kCMTimeZero exportMode:YES longSide:489 * 2];
        _imgView = [[UIImageView alloc] initWithImage:img];
        _imgView.contentMode = UIViewContentModeScaleAspectFill;
        _imgView.clipsToBounds = YES;
    }
    return _imgView;
}

- (UIButton *)coverEditBtn {
    if(!_coverEditBtn) {
        _coverEditBtn = [UIButton buttonWithType:UIButtonTypeSystem];
        [_coverEditBtn setTitle:NSLocalizedString(@"Edit.cover", "编辑封面") forState:UIControlStateNormal];

        [_coverEditBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal]; // 设置文字颜色为白色
        
        // 设置半透明黑色背景
        _coverEditBtn.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.45]; // 半透明黑色
    }
    return _coverEditBtn;
}
@end
