//
//  TAVPublishEditDescribeBoxView.m
//  TAVMagicApp
//
//  Created by penghuixu on 2025/2/5.
//

#import "TAVPublishEditDescribeBoxView.h"
@import Masonry;

@interface TAVPublishEditDescribeBoxView () <UITextViewDelegate>
@property (nonatomic, strong) UITextView *textView;
@property (nonatomic, strong) UILabel *placeholderLabel;

@end

@implementation TAVPublishEditDescribeBoxView
- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];

    if (self) {
        UIButton *tagButton = [UIButton new];
//        [tagButton setTitle:@"#Hashtags" forState:UIControlStateNormal]; //设置按钮标题
        [tagButton setTitle:NSLocalizedString(@"#Hashtags","#话题标签") forState:UIControlStateNormal];

        [tagButton setTitleColor:[UIColor colorWithRed:102/255.0 green:102/255.0 blue:102/255.0 alpha:1/1.0] forState:UIControlStateNormal];
        tagButton.backgroundColor = [UIColor colorWithRed:237/255.0 green:237/255.0 blue:237/255.0 alpha:1/1.0];
        tagButton.titleLabel.font = [UIFont systemFontOfSize:12];
        tagButton.layer.cornerRadius = 10.5;
        tagButton.contentEdgeInsets = UIEdgeInsetsMake(0, 10, 0, 10); // 上、左、下、右的边距

        [self addSubview:tagButton];
        [tagButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(0);
            make.bottom.offset(0);
            make.height.offset(21);
        }];
        
        UIButton *atButton = [UIButton new];
        [atButton setTitle:NSLocalizedString(@"@Friend","@朋友") forState:UIControlStateNormal];
        
        [atButton setTitleColor:[UIColor colorWithRed:102/255.0 green:102/255.0 blue:102/255.0 alpha:1/1.0] forState:UIControlStateNormal];
        atButton.backgroundColor = [UIColor colorWithRed:237/255.0 green:237/255.0 blue:237/255.0 alpha:1/1.0];
        atButton.titleLabel.font = [UIFont systemFontOfSize:12];
        atButton.layer.cornerRadius = 10.5;
        atButton.contentEdgeInsets = UIEdgeInsetsMake(0, 10, 0, 10); // 上、左、下、右的边距

        [self addSubview:atButton];
        [atButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(tagButton.mas_right).offset(10);
            make.bottom.offset(0);
            make.height.offset(21);
        }];

        [self.textView addSubview:self.placeholderLabel];
        [self.placeholderLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(5);
            make.top.offset(7);
            make.height.offset(20);
        }];
        [self addSubview:self.textView];
        [self.textView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.right.offset(0);
            make.bottom.equalTo(tagButton.mas_top).offset(-10);
        }];

        
        // 更新占位符的显示状态
        [self updatePlaceholderVisibility];
        
    }
    return self;
}


- (void)textViewDidChange:(UITextView *)textView {
    [self updatePlaceholderVisibility];
}


// 更新占位符的显示状态
- (void)updatePlaceholderVisibility {
    self.placeholderLabel.hidden = self.textView.text.length > 0;
}



#pragma mark lazy

- (UITextView *)textView {
    if (!_textView) {
        _textView = [[UITextView alloc] init];
        _textView.delegate = self;
        _textView.text = @""; // 默认文本
//        _textView
        _textView.backgroundColor = [UIColor clearColor]; // 可选：设置背景颜色为透明
        _textView.font = [UIFont systemFontOfSize:15 weight:UIFontWeightRegular]; // 字体设置
        _textView.layer.borderWidth = 0; // 设置边框宽度为 0
        _textView.editable = YES; // 设置为可编辑
        _textView.scrollEnabled = YES; // 设置为可滚动
    }
    return _textView;
}

- (UILabel *)placeholderLabel {
    if(!_placeholderLabel) {
        // 创建占位符 UILabel
        _placeholderLabel = UILabel.new;
        _placeholderLabel.text = NSLocalizedString(@"Describe.your.video","@朋友");
        _placeholderLabel.textColor = [UIColor lightGrayColor];
        _placeholderLabel.font = [UIFont systemFontOfSize:15 weight:UIFontWeightRegular]; // 与 UITextView 字体一致
        _placeholderLabel.layer.borderWidth = 0;
    }
    return _placeholderLabel;
}
@end
