//
//  TAVTemplateNavView.m
//  TAVMagicApp
//
//  Created by penghuixu on 2025/2/5.
//

#import "TAVPublishNavView.h"
@import Masonry;

@interface TAVPublishNavView ()
@property (nonatomic, strong) UILabel *titleLabel;
@property (nonatomic, weak) UIViewController *sender;
@end

@implementation TAVPublishNavView
- (instancetype)initWithTitle:(NSString *)title sender:(UIViewController *)sender {
    self = [self initWithFrame:CGRectZero];
    if (self) {
        self.titleLabel.text = title;
        self.sender = sender;
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        _backBtn = [UIButton buttonWithType:UIButtonTypeSystem];
        [_backBtn setBackgroundImage:[UIImage imageNamed:@"icon_edit_nav_back_black"]
                            forState:UIControlStateNormal];
        _backBtn.tintColor = UIColor.blackColor;
        [self addSubview:_backBtn];
        
        _titleLabel = UILabel.new;
        _titleLabel.textColor = UIColor.blackColor;
        _titleLabel.font = [UIFont fontWithName:@"SFUIText" size:18];
        [self addSubview:_titleLabel];
        
        [_backBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.offset(0);
            make.left.offset(15);
            make.width.offset(11);
            make.height.offset(18);
        }];
        
        [_titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.center.offset(0);
        }];
    }
    return self;
}

@end
