//
//  TAVTemplateSet.h
//  AFNetworking
//
//  Created by Robin on 2024/7/22.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface TAVTemplateItem : NSObject
@property (nonatomic, assign) NSUInteger index;
@property (nonatomic, copy) NSString *itemId;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *durationDesc;
@property (nonatomic, copy) NSString *replaceDesc;
@property (nonatomic, copy) NSString *shortDesc;
@property (nonatomic, copy) NSString *tagList;
@property (nonatomic, copy) NSString *materialDescription;
@property (nonatomic, copy) NSString *topic;
@property (nonatomic, copy) NSString *mediaTypeSelected;
@property (nonatomic, copy) NSString *video;
@property (nonatomic, copy) NSString *motion;
@property (nonatomic, copy) NSString *templatePath;
@property (nonatomic, copy) NSString *bgm;
@end

@interface TAVTemplateSet : NSObject
@property (nonatomic, assign, readonly) NSInteger category;
@property (nonatomic, copy, readonly) NSArray<TAVTemplateItem *> *templates;
@property (nonatomic, copy, readonly) NSString *templateDir;
+ (instancetype)Template:(NSString *)templateDir;
@end

NS_ASSUME_NONNULL_END
