//
//  TAVTemplateSet.m
//  AFNetworking
//
//  Created by Robin on 2024/7/22.
//

#import "TAVTemplateSet.h"
#import "NSObject+TAV_JSON.h"

@implementation TAVTemplateItem
+ (NSDictionary<NSString *,NSString *> *)tav_keyMapping {
    return @{
        @"itemId":@"id",
        @"templatePath":@"template",
    };
}
@end

@implementation TAVTemplateSet

+ (NSDictionary<NSString *,Class> *)tav_arrayClassForProperties {
    return @{
        @"templates" : TAVTemplateItem.class
    };
}

+ (instancetype)Template:(NSString *)templateDir {
    NSString *jsonPath = [templateDir stringByAppendingPathComponent:@"template_config.json"];
    if (![[NSFileManager defaultManager] fileExistsAtPath:jsonPath]) {
        NSLog(@"文件不存在");
        return nil;
    }
    NSData *data = [[NSData alloc] initWithContentsOfFile:jsonPath];
    NSError *error;
    NSDictionary* jsonConfig = [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:&error];
    if (error) {
        NSLog(@"解析失败");
        return nil;
    }
    return [[self alloc] init:jsonConfig templateDir:templateDir];
}

- (instancetype)init:(NSDictionary *)jsonConfig templateDir:(NSString *)templateDir {
    self = [super init];
    if (self) {
        [self tav_setupWithJsonObject:jsonConfig];
        for (TAVTemplateItem *item in _templates) {
            
            item.video = [templateDir stringByAppendingPathComponent:item.video];
            if (item.motion.length > 0) {
                item.motion = [templateDir stringByAppendingPathComponent:item.motion];
            } else {
                item.motion = [templateDir stringByAppendingFormat:@"/%@/template.png", item.itemId];
            }
            item.templatePath = [templateDir stringByAppendingPathComponent:item.templatePath];
            item.bgm = [templateDir stringByAppendingPathComponent:item.bgm];
        }
    }
    return self;
}

@end
