//
//  NSObject+TAV_JSON.m
//  TXSkyTool
//
//  Created by Robin on 2023/5/23.
//

#import "NSObject+TAV_JSON.h"
#include <objc/runtime.h>

@implementation NSObject (TAV_JSON)

+ (NSDictionary<NSString *, NSString *> *)tav_keyMapping {
    return nil;
}

- (NSArray *)sky_jsonFromArray {
    NSMutableArray *json = [[NSMutableArray alloc] initWithArray:(NSArray *)self];
    NSInteger count = json.count;
    for (NSInteger idx = 0; idx < count; ++idx) {
        NSObject *obj = json[idx];
        if ([obj isKindOfClass:[NSNumber class]] || [obj isKindOfClass:[NSString class]]) {
            json[idx] = obj;
        } else {
            json[idx] = [obj tav_jsonObject];
        }
    }
    return [json copy];
}

- (NSDictionary *)sky_jsonFromDictionary {
    NSMutableDictionary *json = [[NSMutableDictionary alloc] initWithDictionary:(NSDictionary *)self];
    [json enumerateKeysAndObjectsUsingBlock:^(id  _Nonnull key, id  _Nonnull obj, BOOL * _Nonnull stop) {
        if ([obj isKindOfClass:[NSNumber class]] || [obj isKindOfClass:[NSString class]]) {
            json[key] = obj;
        } else {
            json[key] = [obj tav_jsonObject];
        }
    }];
    return [json copy];
}

- (id)tav_jsonObject {
    if ([self isKindOfClass:[NSArray class]]) {
        return [self sky_jsonFromArray];
    }
    
    if ([self isKindOfClass:[NSDictionary class]]) {
        return [self sky_jsonFromDictionary];
    }
    
    NSDictionary *keyMap = [[self class] tav_keyMapping];
    
    NSMutableDictionary *json = [NSMutableDictionary new];
    
    unsigned int count;
    Ivar *vars = class_copyIvarList([self class], &count);
    for (int i = 0; i < count; i++) {
        Ivar var = vars[i];
        const char *name = ivar_getName(var);
        NSString *propertyName = [NSString stringWithUTF8String:name];
        if ([propertyName hasPrefix:@"_"]) {
            propertyName = [propertyName substringFromIndex:1];
        }
        id value = [self valueForKey:propertyName];
        if (!value) {
            continue;
        }
        NSString *jsonKey = keyMap[propertyName] ?: propertyName;
        if ([value isKindOfClass:[NSNumber class]] || [value isKindOfClass:[NSString class]]) {
            json[jsonKey] = value;
        } else {
            json[jsonKey] = [value tav_jsonObject];
        }
    }
    free(vars);
    
    return [json copy];
}

- (NSString *)tav_jsonString {
    NSError *error;
    NSData *data = [NSJSONSerialization dataWithJSONObject:[self tav_jsonObject] options:NSJSONWritingPrettyPrinted error:&error];
    if (!data) {
        NSAssert(NO, @"序列化失败：%@", error);
        return @"{}";
    }
    return [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
}

- (void)tav_setupWithJsonString:(NSString *)jsonString {
    if ([self isKindOfClass:[NSArray class]]
        || [self isKindOfClass:[NSDictionary class]]) {
        NSAssert(NO, @"不可以使用json初始化 数组 和 字典");
        return;
    }
    @autoreleasepool {
        NSData *data = [jsonString dataUsingEncoding:NSUTF8StringEncoding];
        if (!data) {
            return;
        }
        NSError *error;
        NSDictionary *json = [NSJSONSerialization JSONObjectWithData:data options:(NSJSONReadingMutableContainers) error:&error];
        if ([json isKindOfClass:[NSDictionary class]]) {
            [self _sky_setupWithJsonObject:json];
        }
    }
}

- (void)tav_setupWithJsonObject:(NSDictionary *)jsonObject {
    if ([self isKindOfClass:[NSArray class]]
        || [self isKindOfClass:[NSDictionary class]]) {
        NSAssert(NO, @"不可以使用json初始化 数组 和 字典");
        return;
    }
    @autoreleasepool {
        [self _sky_setupWithJsonObject:jsonObject];
    }
}

- (void)_sky_setupWithJsonObject:(NSDictionary *)jsonObject {
    NSDictionary<NSString *, Class> *arrayClassMap = [[self class] tav_arrayClassForProperties];
    NSDictionary<NSString *, NSString *> *keyMap = [[self class] tav_keyMapping];
    unsigned int count;
    Ivar *vars = class_copyIvarList([self class], &count);
    for (int i = 0; i < count; i++) {
        Ivar var = vars[i];
        NSString *propertyName = [[NSString alloc] initWithUTF8String:ivar_getName(var)];
        if ([propertyName hasPrefix:@"_"]) {
            propertyName = [propertyName substringFromIndex:1];
        }
        NSString *jsonKey = keyMap[propertyName] ?: propertyName;
        id value = jsonObject[jsonKey];
        if (!value) {
            continue;
        }
        
        if ([value isKindOfClass:[NSNumber class]]
            || [value isKindOfClass:[NSString class]]) {
            [self setValue:value forKey:propertyName];
            continue;
        }
        
        NSString *typeName = [[NSString alloc] initWithUTF8String:ivar_getTypeEncoding(var)];
        typeName = [typeName stringByTrimmingCharactersInSet:[NSCharacterSet punctuationCharacterSet]];
        Class propertyClz = NSClassFromString(typeName);
        
        if (!propertyClz) {
            NSAssert(NO, @"检测json与model数据类型是否匹配");
            continue;
        }
        
        if ([value isKindOfClass:[NSDictionary class]]) {
            if ([propertyClz isSubclassOfClass:[NSDictionary class]]) {
                [self setValue:value forKey:propertyName];
            } else if(![propertyClz isSubclassOfClass:[NSArray class]]) {
                NSObject *obj = [propertyClz new];
                [obj tav_setupWithJsonObject:value];
                [self setValue:obj forKey:propertyName];
            } else {
                NSAssert(NO, @"检测json与model数据类型是否匹配");
            }
        } else if ([value isKindOfClass:[NSArray class]]) {
            if([propertyClz isSubclassOfClass:[NSArray class]]) {
                Class elementClass = arrayClassMap[propertyName];
                if (elementClass) {
                    NSMutableArray *array = [NSMutableArray array];
                    for (NSDictionary *itemDict in value) {
                        NSObject *obj = [elementClass new];
                        [obj tav_setupWithJsonObject:itemDict];
                        [array addObject:obj];
                    }
                    [self setValue:[array copy] forKey:propertyName];
                } else {
                    [self setValue:value forKey:propertyName];
                }
            } else {
                NSAssert(NO, @"检测json与model数据类型是否匹配");
            }
        }
    }
    free(vars);
}

+ (NSDictionary<NSString *, Class> *)tav_arrayClassForProperties {
    return @{};
}

@end
