//
//  TAVTemplateDetailViewController+CutSame.m
//  TAVMagicDemo
//
//  Created by Robin on 2024/7/25.
//

#import "TAVTemplateDetailViewController+CutSame.h"
#import "AppConfigManager.h"
#import "TAVTemplateSet.h"
#import "TAVTemplateEditorViewController.h"
#import <TAVMagicUIKit/TAVAlbumPlaceholderAssetSelectorView.h>
#import <TAVMagicUIKit/TAVTextToastView.h>
#import <TAVMagicUIKit/TAVAlbumAssetCustomCollectionViewCell.h>
#import <TAVMagicUIKit/TAVAlbumCustomPreviewViewController.h>

@implementation TAVTemplateDetailViewController (CutSame)
- (void)cutSameAction:(UIButton *)sender {
    [self setupSeniorEditor:^{
        [TAVAlbumAuthorizer checkAlbumAuthorize:^(PHAuthorizationStatus status) {
            [self showPickerVC];
        }];
    }];
}

- (void)setupSeniorEditor:(dispatch_block_t)completion {
    [[AppConfigManager sharedManager] setTELicense:^(NSInteger authresult, NSString * _Nonnull errorMsg) {
        if (authresult == 0) {
            !completion ?: completion();
        }
    }];
}

- (void)createEditor {
    NSString *bundlePath = [[NSBundle mainBundle] pathForResource:@"LightCore" ofType:@"bundle"];
    self.editor = [[TAVEditor alloc] initWithRenderSize:CGSizeZero assetsPath:bundlePath];
}

- (void)showPickerVC {
    if (self.editor == nil) {
        [self createEditor];
    }
    [self.editor clearAll];
    
    TAVAlbumPickerOptions *options = [self albumOptionsForEditor];
    TAVAlbumPickerController *pickerController = [[TAVAlbumPickerController alloc] initWithOptions:options];
    pickerController.modalPresentationStyle = UIModalPresentationFullScreen;
    pickerController.pickerDelegate = self;
    pickerController.context.options.autoDismiss = YES;
    [self presentViewController:pickerController animated:YES completion:nil];
}

- (TAVAlbumPickerOptions *)albumOptionsForEditor {
    TAVTemplateConfig *templateConfig = [self.editor getTemplateConfig:self.item.templatePath];
//    [self setupMusic:templateConfig.clipAudioHolders.firstObject];
    TAVAlbumPickerOptions *options = [TAVAlbumPickerFactory defaultAlbumPickerOptions];
    switch (templateConfig.mediaType) {
        case TAVTemplateMediaTypeVideo:
            options.mediaType = TAVAlbumAssetTypeVideo;
            break;
        case TAVTemplateMediaTypeImage:
            options.mediaType = TAVAlbumAssetTypeImage;
            break;
        case TAVTemplateMediaTypeMulti:
            options.mediaType = TAVAlbumAssetTypeAll;
            break;
    }
    options.minimumSelectionCount = templateConfig.minAssetCount;
    options.maximumSelectionCount = templateConfig.maxAssetCount;
    options.customViewOptions.albumAssetCollectionViewCellClass = TAVAlbumAssetCustomCollectionViewCell.class;
    options.customViewOptions.albumPreviewViewControlleClass = TAVAlbumCustomPreviewViewController.class;
    if (templateConfig.minAssetCount == templateConfig.maxAssetCount) {
        options.pattern = TAVAlbumPatternRepeatedSelection;
        options.customData = templateConfig;
        options.customViewOptions.albumAssetSelectorViewClass = TAVAlbumPlaceholderAssetSelectorView.class;
        options.assetSelectorViewTips = [NSString stringWithFormat:@"请选择%d个照片/视频", templateConfig.maxAssetCount];
        self.stablePlaceholderTemplate = YES;
    } else {
        options.assetSelectorViewTips = [NSString stringWithFormat:@"请选择%d~%d个照片/视频", templateConfig.minAssetCount, templateConfig.maxAssetCount];
        self.stablePlaceholderTemplate = NO;
    }
    return options;
}


#pragma mark - TAVAlbumPickerControllerDelegate
- (void)albumPickerController:(TAVAlbumPickerController *)pickerController
  didFinishPickingAlbumAssets:(NSArray<TAVAlbumAsset*> *)albumAssets {
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_HIGH, 0), ^{
//        [self.editor setTemplate:self.item.templatePath];
        for (TAVAlbumAsset *mediaItem in albumAssets) {
            if (mediaItem.mediaType == TAVAlbumAssetTypeVideo) {
                __block AVURLAsset *urlAsset;
                dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
                PHVideoRequestOptions *options = [[PHVideoRequestOptions alloc] init];
                options.networkAccessAllowed = NO;
                [PHImageManager.defaultManager requestAVAssetForVideo:mediaItem.asset options:options resultHandler:^(AVAsset * _Nullable asset, AVAudioMix * _Nullable audioMix, NSDictionary * _Nullable info) {
                    urlAsset = (AVURLAsset *)asset;
                    dispatch_semaphore_signal(semaphore);
                }];
                dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
                int ret = [self.editor addVideoClip:[urlAsset URL].path];
                NSLog(@">>>add video result: %d", ret);
            } else if (mediaItem.mediaType == TAVAlbumAssetTypeImage) {
                PHAssetResource *imageRes = [PHAssetResource assetResourcesForAsset:mediaItem.asset].lastObject;
                NSURL *imageUrl = [imageRes valueForKey:@"privateFileURL"];
                int ret = [self.editor addImageClip:imageUrl.path duration:kCMTimeZero];
                NSLog(@">>>add image result: %d", ret);
            }
        }
        dispatch_async(dispatch_get_main_queue(), ^{
            [self pushTestPlayViewController:albumAssets];
        });
    });
}

- (void)albumPickerController:(TAVAlbumPickerController *)pickerController showAlertTips:(NSString *)alertTips {
    [TAVTextToastView showToast:alertTips duration:2.0];
}

- (void)pushTestPlayViewController:(NSArray<TAVAlbumAsset*> *)selectAssets {
    
    [self.editor setTemplate:self.item.templatePath];
    
    TAVTemplateEditorViewController *viewController = [[TAVTemplateEditorViewController alloc] init];
    viewController.editor = self.editor;
    viewController.selectedAsset = selectAssets;
    viewController.bgmPath = self.item.bgm;

    [self.navigationController setNavigationBarHidden:YES];
    [self.navigationController pushViewController:viewController animated:YES];
    self.editor = nil;
}

@end
