//
//  TAVTemplateListViewController.m
//  TAVMagicUIKit
//
//  Created by Robin on 2024/7/22.
//

#import "TAVTemplateListViewController.h"
#import "TAVTemplateSet.h"
#import "TAVTemplateNavView.h"
#import "TAVTemplateCell.h"
#import "TAVTemplateDetailViewController.h"
#import <TAVMagicUIKit/UIColor+TAVUtil.h>
@import Masonry;

@interface TAVTemplateListViewController ()<UICollectionViewDataSource, UICollectionViewDelegate>
@property (nonatomic, strong) TAVTemplateSet *templateSet;
@property (nonatomic, strong) TAVTemplateNavView *navView;
@property (nonatomic, strong) UICollectionView *templatesView;
@end

@implementation TAVTemplateListViewController

+ (instancetype)templateViewController:(NSString *)templatePath {
    TAVTemplateSet *templateSet = [TAVTemplateSet Template:templatePath];
    if (templateSet) {
        __auto_type vc = TAVTemplateListViewController.new;
        vc.templateSet = templateSet;
        return vc;
    }
    return nil;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor tvc_colorWithHexString:@"#1F2024"];;
    
    [self.view addSubview:self.navView];
    [self.navView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.offset(0);
        make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop);
        make.height.offset(44);
    }];
    
    [self.view addSubview:self.templatesView];
    [self.templatesView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.navView.mas_bottom);
        make.left.right.offset(0);
        make.bottom.equalTo(self.view.mas_safeAreaLayoutGuideBottom);
    }];
}

#pragma mark - UICollectionViewDelegate
- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.item >= _templateSet.templates.count) {
        return;
    }
    TAVTemplateItem *item = _templateSet.templates[indexPath.item];
    TAVTemplateDetailViewController *detailPage = [[TAVTemplateDetailViewController alloc] init:item];
    [self.navigationController pushViewController:detailPage animated:YES];
}

#pragma mark - UICollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return _templateSet.templates.count;
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.item >= _templateSet.templates.count) {
        return UICollectionViewCell.new;
    }
    TAVTemplateCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass(TAVTemplateCell.class) forIndexPath:indexPath];
    TAVTemplateItem *item = _templateSet.templates[indexPath.item];
    [cell update:item];
    return cell;
}

#pragma mark - lazy
- (TAVTemplateNavView *)navView {
    if (!_navView) {
        _navView = [[TAVTemplateNavView alloc] initWithTitle:NSLocalizedString(@"Home.Creation.Template", "剪同款") sender:self];
    }
    return _navView;
}

- (UICollectionView *)templatesView {
    if (!_templatesView) {
        UICollectionViewFlowLayout *flowLayout = [[UICollectionViewFlowLayout alloc] init];
        __auto_type size = self.view.frame.size;
        flowLayout.itemSize = CGSizeMake(size.width / 2 - 5, 324);
        _templatesView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:flowLayout];
        _templatesView.dataSource = self;
        _templatesView.delegate = self;
        _templatesView.backgroundColor = UIColor.blackColor;
        
        [_templatesView registerClass:TAVTemplateCell.class forCellWithReuseIdentifier:NSStringFromClass(TAVTemplateCell.class)];
    }
    return _templatesView;
}

@end
