//
//  TAVVideoPlayerViewController.h
//  TAVMagicApp
//
//  Created by v_zwtzzhou on 2024/7/23.
//

#import <UIKit/UIKit.h>
#import <CoreMedia/CoreMedia.h>
#import "TAVMagic/TAVEditorDefinitions.h"
#import <TAVMagic/TAVEditor.h>
#import <TAVMagicUIKit/TAVAlbumAsset.h>

NS_ASSUME_NONNULL_BEGIN

@interface TAVVideoPlayerViewController : UIViewController<TAVEditorPlayerObserver>

@property (nonatomic, readonly) UIView *playerView;
@property (nonatomic, readonly) UIImageView *thumbImageView;
@property (nonatomic, readonly) TAVPreviewParam *previewParam;
@property (nonatomic, strong) NSArray<TAVAlbumAsset *> *assets;
@property (nonatomic, weak) id<TAVEditorPlayerObserver>observer;
@property (nonatomic, weak) TAVEditor *editor;
@property (nonatomic, readonly) BOOL isPlaying;
@property (nonatomic, assign) CMTime progress;
@property (nonatomic, assign) CMTime duration;

- (void)play;
- (void)pause;
- (void)resumeFromLastPausing;
- (void)seekTo:(CMTime)time;
- (void)setBgmPath:(NSString *)bgmPath;

@end

NS_ASSUME_NONNULL_END
