//
//  TAVTemplateCell.m
//  TAVMagicUIKit
//
//  Created by Robin on 2024/7/23.
//

#import "TAVTemplateCell.h"
#import "TAVTemplateSet.h"
@import YYImage;
@import Masonry;

@interface TAVTemplateCell ()
@property (nonatomic, strong) TAVTemplateItem *item;
@property (nonatomic, strong) YYAnimatedImageView *animatedView;
@property (nonatomic, strong) UILabel *nameLabel;
@property (nonatomic, strong) UILabel *tagListLabel;
@end

@implementation TAVTemplateCell

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self.contentView addSubview:self.animatedView];
        [self.contentView addSubview:self.nameLabel];
        [self.contentView addSubview:self.tagListLabel];
        [self.tagListLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(0);
            make.bottom.offset(0);
            make.width.lessThanOrEqualTo(self.contentView);
        }];
        [self.nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.equalTo(self.tagListLabel.mas_top).offset(-5);
            make.left.offset(0);
            make.width.lessThanOrEqualTo(self.contentView);
        }];
        [self.animatedView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.left.right.mas_equalTo(0);
            make.bottom.mas_equalTo(-44);
        }];
    }
    return self;
}

- (void)update:(TAVTemplateItem *)item {
    _item = item;
    self.nameLabel.text = item.name;
    self.tagListLabel.text = item.tagList;
    
    YYImage *image = [YYImage imageWithContentsOfFile:item.motion];
//    CGSize imageSize = image.size;
//    [self.animatedView mas_remakeConstraints:^(MASConstraintMaker *make) {
//        make.top.left.right.mas_equalTo(0);
//        make.height.mas_equalTo(self.animatedView.mas_width).multipliedBy(imageSize.height / imageSize.width);
//    }];
    self.animatedView.image = image;
}


#pragma mark - lazy
- (YYAnimatedImageView *)animatedView {
    if (!_animatedView) {
        _animatedView = [[YYAnimatedImageView alloc] initWithFrame:self.bounds];
        _animatedView.backgroundColor = UIColor.blackColor;
        _animatedView.contentMode = UIViewContentModeScaleAspectFill;
        _animatedView.layer.cornerRadius = 8;
        _animatedView.clipsToBounds = YES;
    }
    return _animatedView;
}

- (UILabel *)nameLabel {
    if (!_nameLabel) {
        _nameLabel = UILabel.new;
        _nameLabel.textColor = UIColor.whiteColor;
        _nameLabel.numberOfLines = 2;
        _nameLabel.font = [UIFont systemFontOfSize:14];
//        _nameLabel.font = [UIFont boldSystemFontOfSize:16];
        _nameLabel.textAlignment = NSTextAlignmentLeft;
    }
    return _nameLabel;
}

- (UILabel *)tagListLabel {
    if (!_tagListLabel) {
        _tagListLabel = UILabel.new;
        _tagListLabel.textColor = UIColor.whiteColor;
        _tagListLabel.numberOfLines = 1;
        _tagListLabel.font = [UIFont systemFontOfSize:10];
        _tagListLabel.textAlignment = NSTextAlignmentLeft;
    }
    return _tagListLabel;
}

@end
