//
//  TAVTemplateEditorBottomView.m
//  TAVMagicApp
//
//  Created by jasonggao on 2025/5/29.
//

#import "TAVTemplateEditorBottomView.h"
#import "TAVTemplateEditorBottomCell.h"
#import <Masonry/Masonry.h>
#import <Photos/Photos.h>
#import <TAVMagicUIKit/UIColor+TAVUtil.h>

@interface TAVTemplateEditorBottomView ()<UICollectionViewDataSource, UICollectionViewDelegate>
@property (nonatomic, strong, readwrite) UIButton *playButton;
@property (nonatomic, strong, readwrite) UISlider *progressSlider;
@property (nonatomic, strong, readwrite) UILabel *timeLabel;
@property (nonatomic, strong) UICollectionView *collectionView;

@end

@implementation TAVTemplateEditorBottomView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    [self addSubview:self.playButton];
    [self.playButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(11);
        make.top.offset(13);
        make.width.height.mas_equalTo(32);
    }];
    [self addSubview:self.timeLabel];
    [self.timeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.offset(-10);
        make.centerY.equalTo(self.playButton);
        make.width.mas_greaterThanOrEqualTo(70);
        make.height.mas_equalTo(20);
    }];
    [self addSubview:self.progressSlider];
    [self.progressSlider mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.playButton.mas_right).offset(5);
        make.right.equalTo(self.timeLabel.mas_left).offset(-8);
        make.centerY.equalTo(self.playButton);
        make.height.mas_equalTo(20);
    }];
    [self addSubview:self.collectionView];
    [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.offset(0);
        make.top.equalTo(self.playButton.mas_bottom).offset(20);
        make.height.mas_equalTo(80);
    }];
}

- (void)setAssets:(NSArray<TAVAlbumAsset *> *)assets {
    _assets = assets;
    [self.collectionView reloadData];
}

#pragma mark - Action
- (void)playAction {
    if ([self.delegate respondsToSelector:@selector(bottomViewDidPlayAction)]) {
        [self.delegate bottomViewDidPlayAction];
    }
}

- (void)didStartDragging {
    if ([self.delegate respondsToSelector:@selector(bottomViewDidSliderStartDragging)]) {
        [self.delegate bottomViewDidSliderStartDragging];
    }
}

- (void)didChangeTime:(UISlider *)slider {
    if ([self.delegate respondsToSelector:@selector(bottomViewDidSliderDragging:)]) {
        [self.delegate bottomViewDidSliderDragging:slider.value];
    }
}

- (void)didEndDragging {
    if ([self.delegate respondsToSelector:@selector(bottomViewDidSliderEndDragging)]) {
        [self.delegate bottomViewDidSliderEndDragging];
    }
}

#pragma mark - Lazy
- (UIButton *)playButton{
    if (!_playButton){
        _playButton = [UIButton buttonWithType:UIButtonTypeCustom];
        [_playButton setImage:[UIImage imageNamed:@"icon_edit_player_pause_normal"]
                     forState:UIControlStateNormal];
        [_playButton setImage:[UIImage imageNamed:@"icon_edit_player_play_normal"] forState:UIControlStateSelected];
        [_playButton addTarget:self action:@selector(playAction)
              forControlEvents:UIControlEventTouchUpInside];
    }
    return _playButton;
}

- (UISlider *)progressSlider{
    if (!_progressSlider){
        _progressSlider = [[UISlider alloc] init];
        _progressSlider.maximumValue = 1.0;
        _progressSlider.minimumValue = 0.0;
        _progressSlider.value = 0;
        _progressSlider.continuous = YES;
        _progressSlider.minimumTrackTintColor = [UIColor tvc_colorWithHexString:@"#DE6B1F"];
        _progressSlider.maximumTrackTintColor = [UIColor lightGrayColor];
        [_progressSlider setThumbImage:[UIImage imageNamed:@"TAVMediaPlayer_progress"]
                              forState:UIControlStateNormal];
        [_progressSlider addTarget:self action:@selector(didStartDragging)
                  forControlEvents:UIControlEventTouchDown];
        [_progressSlider addTarget:self action:@selector(didChangeTime:)
                  forControlEvents:UIControlEventValueChanged];
        [_progressSlider addTarget:self action:@selector(didEndDragging)
                  forControlEvents:UIControlEventTouchUpInside|UIControlEventTouchUpOutside|UIControlEventTouchCancel];
    }
    return _progressSlider;
}

- (UILabel *)timeLabel{
    if (!_timeLabel) {
        _timeLabel = [[UILabel alloc] init];
        _timeLabel.font = [UIFont systemFontOfSize:14];
        _timeLabel.textAlignment = NSTextAlignmentCenter;
        _timeLabel.text = @"00:00/00:00";
        _timeLabel.textColor = [UIColor whiteColor];
    }
    return _timeLabel;
}

- (UICollectionView *)collectionView {
    if (!_collectionView) {
        UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc] init];
        layout.itemSize = CGSizeMake(50, 50);
        layout.sectionInset = UIEdgeInsetsMake(0, 15, 0, 15);
        layout.minimumInteritemSpacing = 0;
        layout.minimumLineSpacing = 12;
        layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
        
        _collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
        [_collectionView registerClass:[TAVTemplateEditorBottomCell class] forCellWithReuseIdentifier:NSStringFromClass([TAVTemplateEditorBottomCell class])];
        _collectionView.delegate = self;
        _collectionView.dataSource = self;
        _collectionView.showsHorizontalScrollIndicator = NO;
        _collectionView.backgroundColor = [UIColor clearColor];
    }
    return _collectionView;
}

#pragma mark - UICollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.assets.count;
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    TAVTemplateEditorBottomCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([TAVTemplateEditorBottomCell class]) forIndexPath:indexPath];
    [cell configureWithData:self.assets[indexPath.row] imageToVideoDuration:3];
    return cell;
}

@end
