//
//  TAVTemplateNavView.m
//  AFNetworking
//
//  Created by Robin on 2024/7/23.
//

#import "TAVTemplateNavView.h"
@import Masonry;

@interface TAVTemplateNavView ()
@property (nonatomic, strong) UIButton *backBtn;
@property (nonatomic, strong) UILabel *titleLabel;
@property (nonatomic, weak) UIViewController *sender;
@end

@implementation TAVTemplateNavView

- (instancetype)initWithTitle:(NSString *)title sender:(UIViewController *)sender {
    self = [self initWithFrame:CGRectZero];
    if (self) {
        self.titleLabel.text = title;
        self.sender = sender;
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        _backBtn = [UIButton buttonWithType:UIButtonTypeSystem];
        [_backBtn setBackgroundImage:[UIImage imageNamed:@"icon_edit_nav_back_white"]
                            forState:UIControlStateNormal];
        _backBtn.tintColor = UIColor.whiteColor;
        [_backBtn addTarget:self action:@selector(backAction:) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_backBtn];
        
        _titleLabel = UILabel.new;
        _titleLabel.textColor = UIColor.whiteColor;
        [self addSubview:_titleLabel];
        
        [_backBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.offset(0);
            make.left.offset(10);
            make.size.offset(25);
        }];
        
        [_titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.center.offset(0);
        }];
    }
    return self;
}

- (void)backAction:(UIButton *)btn {
    if (self.sender.navigationController) {
        [self.sender.navigationController popViewControllerAnimated:YES];
    } else {
        [self.sender dismissViewControllerAnimated:YES completion:nil];
    }
}

@end
