//
//  TAVTemplatePreviewCell.m
//  TAVMagicApp
//
//  Created by v_zwtzzhou on 2025/5/29.
//

#import "TAVTemplatePreviewCell.h"
@import Masonry;

@interface TAVTemplatePreviewCell ()
@property (nonatomic, strong, readwrite) UIImageView *imageView;
@property (nonatomic, strong) UIView *maskV;
@property (nonatomic, strong) UIImageView *iconImageV;
@property (nonatomic, strong) UILabel *titleLabel;

@end
@implementation TAVTemplatePreviewCell

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI{
    self.layer.cornerRadius = 7;
    self.clipsToBounds = YES;
    
    self.imageView = [[UIImageView alloc] init];
    self.imageView.contentMode = UIViewContentModeScaleAspectFill;
    [self.contentView addSubview:self.imageView];
    self.imageView.layer.cornerRadius = 4;
    self.imageView.clipsToBounds = YES;
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.offset(3);
        make.bottom.right.offset(-3);
    }];
    
    self.maskV = [[UIView alloc] init];
    [self.contentView addSubview:self.maskV];
    self.maskV.layer.cornerRadius = 4;
    self.maskV.clipsToBounds = YES;
    [self.maskV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.offset(3);
        make.bottom.right.offset(-3);
    }];
    self.maskV.backgroundColor = [UIColor colorWithWhite:0 alpha:0.5];
    
    self.iconImageV = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@""]];
    [self.maskV addSubview:self.iconImageV];
    [self.iconImageV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.width.mas_equalTo(20);
        make.top.offset(8);
        make.centerX.offset(0);
    }];
    
    self.titleLabel = [[UILabel alloc] init];
    self.titleLabel.font = [UIFont systemFontOfSize:12];
    self.titleLabel.textAlignment = NSTextAlignmentCenter;
    self.titleLabel.textColor = UIColor.whiteColor;
    self.titleLabel.text = @"Edit";
    [self.maskV addSubview:self.titleLabel];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.offset(0);
        make.bottom.offset(-8);
        make.height.mas_equalTo(14);
        make.width.lessThanOrEqualTo(self.maskV.mas_width);
    }];
    
    self.selected = NO;
}

- (void)setSelected:(BOOL)selected{
    [super setSelected: selected];
    self.backgroundColor = selected ? UIColor.whiteColor : UIColor.clearColor;
    self.maskV.hidden = !selected;
}

@end
