//
//  TAVTemplateVideoSetView.h
//  TAVMagicApp
//
//  Created by jasonggao on 2025/6/3.
//

#import "TAVActionSheetBaseView.h"
#import "TAVVideoSetCell.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, TAVVideoSetResolution) {
    TAVVideoSetResolution540P,
    TAVVideoSetResolution720P,
    TAVVideoSetResolution1080P,
    TAVVideoSetResolution4K
};

@interface TAVTemplateVideoSetView : TAVActionSheetBaseView
@property (nonatomic, assign) TAVVideoSetType type;
@property (nonatomic, assign, readonly) int videoBitRate; // 平均码率
@property (nonatomic, assign, readonly) int frameRate; // 帧率
@property (nonatomic, assign, readonly) TAVVideoSetResolution resolution; // 分辨率
@property (nonatomic, assign, readonly) CGSize resolutionSize; // 分辨率size
@property (nonatomic, strong) NSString *resolutionString; // 分辨率string
@property (nonatomic, copy) void (^ResolutionChange)(TAVVideoSetResolution resolution, NSInteger index);
@property (nonatomic, copy) void (^FrameRateChange)(int frameRate, NSInteger index);
@property (nonatomic, copy) void (^BitRateChange)(float bpp, NSInteger index);
@end

NS_ASSUME_NONNULL_END
