//
//  TAVVideoSetCell.m
//  TAVMagicApp
//
//  Created by jasonggao on 2025/6/3.
//

#import "TAVVideoSetCell.h"
#import <TAVMagicUIKit/UIColor+TAVUtil.h>

@interface TAVVideoSetCell ()
@property (nonatomic, strong, readwrite) UILabel *titleLabel;
@property (nonatomic, strong, readwrite) UILabel *subTitleLabel;
@property (nonatomic, strong) UIImageView *accessoryImageView;
@end

@implementation TAVVideoSetCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self initSubViews];
    }
    return self;
}

- (void)initSubViews {
    self.titleLabel = [[UILabel alloc] init];
    self.titleLabel.textColor = [UIColor whiteColor];
    self.titleLabel.font = [UIFont systemFontOfSize:16];
    [self.contentView addSubview:self.titleLabel];
    
    self.subTitleLabel = [[UILabel alloc] init];
    self.subTitleLabel.textColor = [UIColor whiteColor];
    self.subTitleLabel.font = [UIFont systemFontOfSize:16];
    [self.contentView addSubview:self.subTitleLabel];
    
    self.accessoryImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"icon_template_arrow_down"]];
    [self.contentView addSubview:self.accessoryImageView];
}

- (void)layoutSubviews {
    [super layoutSubviews];
    CGSize contentSize = self.contentView.bounds.size;
    if (self.cellType == TAVVideoSetTypeVideoInfo) {
        self.titleLabel.frame = CGRectMake(12, 0, 50, contentSize.height);
        self.accessoryImageView.frame = CGRectMake(contentSize.width - 34, (contentSize.height - 20) / 2, 20, 20);
        self.subTitleLabel.frame = CGRectMake(contentSize.width - 34 - 60, (contentSize.height - 20) / 2, 55, 20);
    } else {
        self.titleLabel.frame = self.contentView.bounds;
    }
}

- (void)setCellType:(TAVVideoSetType)cellType {
    _cellType = cellType;
    if (cellType == TAVVideoSetTypeVideoInfo) {
        self.subTitleLabel.hidden = self.accessoryImageView.hidden = NO;
        self.titleLabel.textAlignment = NSTextAlignmentLeft;
        self.subTitleLabel.textAlignment = NSTextAlignmentRight;
        self.contentView.backgroundColor = [UIColor tvc_colorWithHexString:@"#2B2C30"];
    } else {
        self.subTitleLabel.hidden = self.accessoryImageView.hidden = YES;
        self.titleLabel.textAlignment = NSTextAlignmentCenter;
        self.contentView.backgroundColor = [UIColor tvc_colorWithHexString:@"#1F2024"];
    }
}

@end
