/*** light-js-config
***/
/**
 * 用于判断节点Slot是数据/事件
 */
var EVENT_SLOT = -1;
var DATA_SLOT = 0;

console.error('customNodeCachedRandom.js load');

function FlowNode() { }

FlowNode.prototype.GenerateRandomValue = function (cachedRandomValue) {
    console.error('customNodeCachedRandom.GenerateRandomValue cachedRandomValue: ' + cachedRandomValue);
    if (cachedRandomValue !== undefined && (!Number.isNaN(cachedRandomValue))) {
        this.outValue = cachedRandomValue;
    } else {
        // generate new random value
        if (this.from === this.to) {
            this.outValue = this.from;
        } else {
            this.outValue = Math.round(Math.round(this.from) + (Math.random() * (this.to - this.from)));
        }

        // save to cache
        var result = new light.MapStringString();
        result.set('lightasset.behaviour.lightTemplateCache', this.outValue.toString());
        this.eventManager.emit(new light.LightAssetStatusEvent(this.entityManager, 'lightAsset.process.result', result));

        console.error('customNodeCachedRandom.GenerateRandomValue New: ' + this.outValue);
    }
}


FlowNode.prototype.Run = function () {
    console.error('customNodeCachedRandom.Run');
    var _thiz = this;
    light.on('UpdateInputEvent', function(params) {
        console.error('customNodeCachedRandom.UpdateInputEvent');
        var cachedRandomValue = undefined;
        var jsonData = params['event.script.params']
        if (jsonData !== undefined && jsonData !== null) {
            var cachedValue = jsonData["lightTemplateCache"];
            console.error('customNodeCachedRandom.UpdateInputEvent cachedValue: ' + cachedValue);
            if (cachedValue !== undefined && cachedValue !== null) {
                cachedRandomValue = parseInt(cachedValue);
            }
        }

        _thiz.called = true;
        _thiz.GenerateRandomValue(cachedRandomValue);
        _thiz.Next();
    });

    setTimeout(function() {
        if (_thiz.called) {
            return;
        }
        _thiz.GenerateRandomValue(undefined);
        _thiz.Next();
    }, 500)
}


FlowNode.prototype.Next = function () {}

FlowNode.definition = {
    meta: { /** TODO: meta对象下的属性需更改，避免冲突 */
        title: '随机数生成(带缓存)', 
        nodeType: 'pro/customNodeCachedRandom',
        category: '自定义',
        description: '随机数生成，支持缓存（下一次进模版复用之前的随机数）',
        group: 'ObjectDisplaySetting',
    },
    outputs: [
        {
            slotType: EVENT_SLOT,
            name: 'Next',
            label: '触发'
        },
        {
            slotType: DATA_SLOT,
            name: 'outValue',
            label: '随机值',
            type: 'integer',
            defaultValue: 0
        }
    ],
    inputs: [
        {
            slotType: EVENT_SLOT,
            name: 'Run',
            label: '产生随机值',
        },
        {
            slotType: DATA_SLOT,
            name: 'from',
            label: '最小值',
            type: 'integer',
            defaultValue: 0
        },
        {
            slotType: DATA_SLOT,
            name: 'to',
            label: '最大值',
            type: 'integer',
            defaultValue: 5
        }
    ]
}

light.FlowNodeClasses = light.FlowNodeClasses || [];
light.FlowNodeClasses.push(FlowNode)
