//
//  TAVBeautyViewController.m
//  TAVMagicApp
//
//  Created by v_zwtzzhou on 2025/5/13.
//

#import "TAVBeautyViewController.h"
#import "TEUIConfig.h"

//@import TEBeautyKit;
@import Masonry;
@interface TAVBeautyViewController ()<YTSDKEventListener, TEPanelViewDelegate>
@end

@implementation TAVBeautyViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view
    self.view.backgroundColor = UIColor.blackColor;
    
    _recordViewController = [[TAVRecordViewController alloc] init];
    [self addChildViewController:_recordViewController];
    [self.view addSubview:self.recordViewController.view];
    self.recordViewController.videoProcessDelegate = self;
//    [self.recordViewController.view mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.right.top.offset(0);
//        make.bottom.equalTo(self.view.mas_safeAreaLayoutGuideBottom).offset(-36);
//    }];
    
    [[TEUIConfig shareInstance] setPanelLevel:S1_07];
 }

- (void)dealloc{
    [self.teBeautyKit onDestroy];
}

- (void)viewWillLayoutSubviews{
    self.recordViewController.view.frame = self.view.bounds;
}

- (void)viewWillAppear:(BOOL)animated{
    [super viewWillAppear:animated];
    if (self.teBeautyKit){
        [self.teBeautyKit onResume];
    }
}

- (void)viewDidAppear:(BOOL)animated{
    [super viewDidAppear:animated];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(viewWillResignActive:)
    name:UIApplicationWillResignActiveNotification object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(viewDidBecomeActive:)
    name:UIApplicationDidBecomeActiveNotification object:nil];
}

- (void)viewWillDisappear:(BOOL)animated{
    [super viewWillDisappear:animated];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIApplicationWillResignActiveNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIApplicationDidBecomeActiveNotification object:nil];
}

// 退后台停止渲染
- (void)viewWillResignActive:(NSNotification *)noti {
    [self.teBeautyKit onPause];
}

// 后台返回恢复动效
- (void)viewDidBecomeActive:(NSNotification *)noti {
    // 恢复动效
    [self.teBeautyKit onResume];
}

#pragma mark - Common
- (void)showPanelView {
    if (!self.tePanelView.superview){
        [self.view addSubview:self.tePanelView];
        [self.tePanelView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(self.view);
            make.centerX.mas_equalTo(self.view);
            make.height.mas_equalTo(200);
            make.bottom.mas_equalTo(self.view.mas_bottom);
        }];
    }
    self.tePanelView.hidden = NO;
}
- (void)hiddenPanelView {
    self.tePanelView.hidden = YES;
}

#pragma mark - Beauty
- (void)setupXMagic{
    __weak __typeof(self)weakSelf = self;
    [TEBeautyKit createXMagic:EFFECT_MODE_PRO onInitListener:^(TEBeautyKit * _Nullable api) {
        __strong typeof(self) strongSelf = weakSelf;
        strongSelf.teBeautyKit = api;
        dispatch_async(dispatch_get_main_queue(), ^{
            strongSelf.tePanelView.teBeautyKit = strongSelf.teBeautyKit;
            [strongSelf.tePanelView setDefaultBeauty];
        });
        [strongSelf.teBeautyKit setLogLevel:YT_SDK_ERROR_LEVEL];
    }];
}

#pragma mark - YTSDKEventListener
- (void)onAIEvent:(id _Nonnull)event{
    
}
- (void)onTipsEvent:(id _Nonnull)event{
    
}
- (void)onAssetEvent:(id _Nonnull)event{
    
}

#pragma mark - TAVRecordProcessDelegate
//处理纹理，接入第三方美颜
- (GLuint)onPreProcessTexture:(GLuint)texture width:(CGFloat)width height:(CGFloat)height{
    if (!_teBeautyKit){
        [self setupXMagic];
    }
    YTProcessOutput *output = [self.teBeautyKit processTexture:texture
                                                  textureWidth:width textureHeight:height
                                                    withOrigin:YtLightImageOriginTopLeft withOrientation:YtLightCameraRotation0];
    return output.textureData.texture;
 }

- (void)showBeautyChanged:(BOOL)open {
    [self.teBeautyKit enableBeauty:open];
}

#pragma mark - Public

-(TEPanelView *)tePanelView{
    if (!_tePanelView) {
        _tePanelView = [[TEPanelView alloc] init:nil comboType:nil];
        _tePanelView.hidden = YES;
        _tePanelView.delegate = self;
    }
    return _tePanelView;
}

@end
