//
//  TAVVideoShootViewController.m
//  TAVMagicApp
//
//  Created by v_zwtzzhou on 2025/5/13.
//

#import "TAVVideoShootViewController.h"
#import <TAVMagicUIKit/UIColor+TAVUtil.h>
#import "TAVSimpleProgressView.h"
#import "TAVVideoAddSoundView.h"
#import <TAVMagicUIKit/TAVAlbumResource.h>
#import <TAVMagicUIKit/TAVEditorPreviewController.h>
#import "MaterialProvider.h"
#import "EditInterceptor.h"
#import "MaterialProvider.h"
#import "TAVSliderControl.h"
#import "TAVProgressButton.h"

#import "TAVPublishController.h"
#import <TAVMagicUIKit/TAVEditorManager.h>

#define BUTTON_TAG_OFFSET 1000
#define SPEED_SELECTOR_HEIGHT 30

typedef NS_ENUM(NSInteger, CaptureMode) {
    CaptureModeStill    = 0,    // # 拍照
    CaptureModeTap      = 1,    // # 单击拍
    CaptureModePress    = 2,    // # 长按拍
};

const CGFloat MIN_VIDEO_DURATION = 6.0;
const CGFloat MAX_VIDEO_DUEATION = 60.0;

@import Masonry;
@interface TAVVideoShootViewController ()<TAVRecordStatusDelegate>{
    BOOL _hiddenNavigationBar;
    NSArray *_speedDataSource;
    BOOL _clickConfirm ;        // 是否主动点击了确认
}
@property (nonatomic, strong) UIButton *closeButton;
@property (nonatomic, strong) UILabel *durationLabel;
@property (nonatomic, strong) TAVSimpleProgressView *videoProgressView;
@property (nonatomic, strong) CAShapeLayer *progressLimitLine;
@property (nonatomic, strong) UIStackView *menuView;
@property (nonatomic, strong) UIButton *flipButton;
@property (nonatomic, strong) UIButton *speedButton;
@property (nonatomic, strong) UIButton *flashButton;
@property (nonatomic, strong) UIButton *micButton;
@property (nonatomic, strong) UIButton *beautyButton;
@property (nonatomic, strong) UIButton *captureButton;
@property (nonatomic, strong) TAVProgressButton *captureProgressButton;
@property (nonatomic, strong) TAVVideoAddSoundView *addSoundView;

@property (nonatomic, strong) UIStackView *speedSelectorView;
@property (nonatomic, strong) UIButton *nextButton;
@property (nonatomic, strong) UIButton *mediaDiscardButton;
@property (nonatomic, strong) UIButton *videoConfirmButton;
@property (nonatomic, strong) MaterialProvider *materialProvider;
@property (nonatomic, strong) TAVSliderControl *recordSwitchControl;    // #拍摄方式选择
@property (nonatomic, assign) CaptureMode captureMode;
@property (nonatomic, weak) UIImageView *photoPreivewImageV;
@property (nonatomic, copy) NSString *photoPath;

@property (nonatomic, assign) NSInteger videoMilliSecond;

@end

@implementation TAVVideoShootViewController

- (void)dealloc{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIApplicationDidEnterBackgroundNotification object:nil];
}

- (void)viewDidLoad{
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor tvc_colorWithHexString:@"#2B2C30"];
    
    [self setupUI];
    [self setupRecordViewController];
    [[NSNotificationCenter defaultCenter] addObserver:self selector: @selector(onApplicationDidEnterBackground:) name:UIApplicationDidEnterBackgroundNotification object:nil];
    UITapGestureRecognizer *_hidePanelTapGesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(handleHidePanelTap:)];
    _hidePanelTapGesture.cancelsTouchesInView = NO;
    [self.view addGestureRecognizer:_hidePanelTapGesture];
}

- (void)viewWillAppear:(BOOL)animated{
    [super viewWillAppear:animated];
    _hiddenNavigationBar = self.navigationController.navigationBarHidden;
    [self.navigationController setNavigationBarHidden:YES];
}

- (void)viewDidDisappear:(BOOL)animated{
    [super viewDidDisappear:animated];
    [self.navigationController setNavigationBarHidden:_hiddenNavigationBar];
}

- (void)onApplicationDidEnterBackground:(NSNotification *)notification{
    if (self.recordViewController.isRecording){
        [self.recordViewController pauseRecord];
    }
}

- (void)handleHidePanelTap:(UITapGestureRecognizer *)gesture {
    CGPoint point = [gesture locationInView:self.view];
    // 处理点击空白区域隐藏美颜面板
    if (self.tePanelView && !self.tePanelView.isHidden) {
        BOOL inBeautyBtn = [self.beautyButton pointInside:[self.beautyButton convertPoint:point fromView:self.view] withEvent:nil];
        BOOL inPanel = [self.tePanelView pointInside:[self.tePanelView convertPoint:point fromView:self.view] withEvent:nil];
        if (!inBeautyBtn && !inPanel) {
            [self hiddenPanelView];
        }
    }
}

- (void)setupUI{
    self.closeButton = [self createCloseButton];
    [self.view addSubview:self.closeButton];
    [self.closeButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(34);
        make.left.offset(6);
        make.top.offset(87);
    }];
    [self.closeButton addTarget:self action:@selector(closeButtonAction:) forControlEvents:UIControlEventTouchUpInside];
    
    self.durationLabel = [self createDureationLabel];
    [self.view addSubview:self.durationLabel];
    
    self.videoProgressView = [self createVideoProgressView];
    self.progressLimitLine = [self createProgressLimitLine];
    [self.videoProgressView.layer addSublayer:self.progressLimitLine];
    [self.view addSubview:self.videoProgressView];
    
    self.menuView = [self createMenuView];
    [self.view addSubview:self.menuView];
    // item(57, 39),spacing 25
    [self.menuView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(57);
        make.top.offset(92);
        make.right.offset(0);
    }];
    self.flipButton = [self createMenuItemButtonWithImage:[UIImage imageNamed:@"menu_flip"]
                                                    title:NSLocalizedString(@"Recorder.menu.Flip", "翻转")];
    self.speedButton = [self createMenuItemButtonWithImage:[UIImage imageNamed:@"menu_speed"]
                                                     title:NSLocalizedString(@"Recorder.menu.Speed", "速度")];
    self.flashButton = [self createMenuItemButtonWithImage:[UIImage imageNamed:@"menu_flash_on"]
                                                     title:NSLocalizedString(@"Recorder.menu.Flash", "闪光灯")];
    [self.flashButton setImage:[UIImage imageNamed:@"menu_flash_off"] forState:UIControlStateSelected];
    self.micButton = [self createMenuItemButtonWithImage:[UIImage imageNamed:@"menu_mic_off"]
                                                   title:NSLocalizedString(@"Recorder.menu.Mic", "麦克风")];
    [self.micButton setImage:[UIImage imageNamed:@"menu_mic_on"] forState:UIControlStateSelected];
    self.micButton = [self createMenuItemButtonWithImage:[UIImage imageNamed:@"menu_mic_on"]
                                                   title:NSLocalizedString(@"Recorder.menu.Mic", "麦克风")];
    [self.micButton setImage:[UIImage imageNamed:@"menu_mic_off"] forState:UIControlStateSelected];
    self.beautyButton = [self createMenuItemButtonWithImage:[UIImage imageNamed:@"menu_beauty"]
                                                      title:NSLocalizedString(@"Recorder.menu.Beauty", "高级美颜")];
    
    [self.flipButton addTarget:self action:@selector(flipButtonAction:) forControlEvents:UIControlEventTouchUpInside];
    [self.speedButton addTarget:self action:@selector(speedButtonAction:) forControlEvents:UIControlEventTouchUpInside];
    [self.flashButton addTarget:self action:@selector(flashButtonAction:) forControlEvents:UIControlEventTouchUpInside];
    [self.micButton addTarget:self action:@selector(micButtonAction:) forControlEvents:UIControlEventTouchUpInside];
    [self.beautyButton addTarget:self action:@selector(beautyButtonAction:) forControlEvents:UIControlEventTouchUpInside];
    
    [self.menuView addArrangedSubview:self.flipButton];
    [self.menuView addArrangedSubview:self.speedButton];
    [self.menuView addArrangedSubview:self.flashButton];
    [self.menuView addArrangedSubview:self.micButton];
    [self.menuView addArrangedSubview:self.beautyButton];
    
    self.captureButton = [self createCaptureButton];
    [self.view addSubview:self.captureButton];
    [self.captureButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(75);
        make.centerX.equalTo(self.view.mas_centerX);
        make.bottom.equalTo(self.view.mas_safeAreaLayoutGuideBottom).offset(-46);
    }];
    
    [self.captureButton addTarget:self action:@selector(captureButtonTouchDownAction:) forControlEvents:UIControlEventTouchDown];
    [self.captureButton addTarget:self action:@selector(captureButtonTouchUpAction:) forControlEvents:UIControlEventTouchUpInside | UIControlEventTouchUpOutside];
    
    self.captureProgressButton = [self captureCaptureProgressButton];
    [self.view addSubview:self.captureProgressButton];
    self.captureProgressButton.hidden = YES;
    [self.captureProgressButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.captureButton.mas_centerX);
        make.centerY.equalTo(self.captureButton.mas_centerY);
        make.height.width.mas_equalTo(120);
    }];
    [self.captureProgressButton addTarget:self action:@selector(captureProgressButtonAction:) forControlEvents:UIControlEventTouchUpInside];
    
    self.addSoundView = [self createAddSoundView];
    [self.view addSubview:self.addSoundView];
    [self.addSoundView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view.mas_centerX);
        make.centerY.equalTo(self.closeButton.mas_centerY);
    }];
    
    __weak __typeof(self)weakSelf = self;
    self.addSoundView.onTap = ^{
        __weak __typeof(self)strongSelf = weakSelf;
        [strongSelf addSoundViewTapAction];
    };
    self.addSoundView.onDiscard = ^{
        __weak __typeof(self)strongSelf = weakSelf;
        [strongSelf addSoundViewDiscardAction];
    };
    
//    self.recordSwitchControl = [self createRecordSwitchControl];
//    [self.view addSubview:self.recordSwitchControl];
//    [self.recordSwitchControl mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.centerX.equalTo(self.view.mas_centerX);
//        make.bottom.equalTo(self.view.mas_safeAreaLayoutGuideBottom).offset(-2);
//        make.height.mas_equalTo(36);
//        make.width.equalTo(self.view.mas_width);
//    }];
//    [self.recordSwitchControl addTarget:self action:@selector(onTapCaptureModeAction:) forControlEvents:UIControlEventValueChanged];
    self.captureMode = CaptureModeTap;
//    self.recordSwitchControl.selectedIndex = CaptureModeTap;
}

- (void)setupRecordViewController{
    self.recordViewController.recordStatusDelegate = self;
    self.recordViewController.exportPath = NSTemporaryDirectory();
    self.recordViewController.minDuration = MIN_VIDEO_DURATION;
    self.recordViewController.maxDuration = MAX_VIDEO_DUEATION;

    __weak __typeof(self)weakSelf = self;
    self.recordViewController.flashChanged = ^(BOOL isOpen) {
        weakSelf.flashButton.selected = isOpen;
    };
    self.recordViewController.cameraChanged = ^(BOOL isFrontCamera) {
        [weakSelf setView:weakSelf.flashButton isEnable:!isFrontCamera];
    };
    self.recordViewController.recordSpeedChanged = ^(TAVVideoRecordSpeedMode recordSpeed) {
        [weakSelf selectSpeedSelectorWithSpeed:recordSpeed];
    };
    self.recordViewController.micChanged = ^(BOOL isMic) {
        weakSelf.micButton.selected = isMic;
    };
    [self.recordViewController setBGMValidCallback:^(BOOL isValid) {
        if (!isValid){
            [weakSelf.addSoundView updateTitle:nil];
        }
        }];
        
    self.recordViewController.isFlash = NO;
    self.recordViewController.isFrontCamera = YES;
    self.recordViewController.recordSpeed = TAVVideoRecordSpeedMode_Standard;
    self.recordViewController.isMic = YES;
}

- (void)viewWillLayoutSubviews{
    self.durationLabel.frame = CGRectMake(10, 60, 100, 12);
    self.videoProgressView.frame = CGRectMake(50, 63, self.view.bounds.size.width - 50 - 10, 6);
    CGFloat limitLeft = self.videoProgressView.bounds.size.width / MAX_VIDEO_DUEATION * MIN_VIDEO_DURATION;
    self.progressLimitLine.frame = CGRectMake(limitLeft, -2, 1, 10);
    //    [self.addSoundView update];
}

- (void)gotoPreviewControllerWithResource:(NSArray<TAVAlbumResource *> *)resources {
    TAVEditorPreviewController *previewVC = [[TAVEditorPreviewController alloc] initWithAssetPath:nil resources:resources];
    previewVC.materialProvider = [MaterialProvider new];
    previewVC.editInterceptor = [EditInterceptor new];
    __weak __typeof(TAVEditorPreviewController *)weakPreviewVC = previewVC;
    [previewVC setNextClickCallback:^{
        __strong typeof(TAVEditorPreviewController *) strongPreviewVC = weakPreviewVC;
        TAVPublishController *publishVC = [[TAVPublishController alloc] initWithEditor:strongPreviewVC.editor];
        [self.navigationController pushViewController:publishVC animated:YES];
    }];
    [self.navigationController pushViewController:previewVC animated:YES];
}


#pragma mark - Button Actions
- (void)closeButtonAction:(UIButton *)sender{
    [self.recordViewController cancelRecord];
    [self.navigationController popViewControllerAnimated:YES];
}

// 按下按钮
- (void)captureButtonTouchDownAction:(UIButton *)sender{
//    if (CaptureModeStill == self.captureMode){
//        [self onPhotoStarted];
//        __weak __typeof(self)weakSelf = self;
//        [self.recordViewController takePhoto:^(UIImage * _Nullable image, NSString * _Nullable path) {
//            __weak __typeof(self)strongSelf = weakSelf;
//            strongSelf.photoPath = path;
//            [strongSelf onPhotoComplete:image];
//        }];
//    } else if (CaptureModePress == self.captureMode){
//        [self.recordViewController resumeRecordWithError:nil];
//    }
    if (self.recordViewController.isRecording){
        [self.recordViewController pauseRecord];
    } else {
        [self.recordViewController resumeRecordWithError:nil];
    }
}

// 松开
- (void)captureButtonTouchUpAction:(UIButton *)sender{
//    if (CaptureModeTap == self.captureMode){
//        if (self.recordViewController.isRecording){
//            [self.recordViewController pauseRecord];
//        } else {
//            [self.recordViewController resumeRecordWithError:nil];
//        }
//    } else if (CaptureModePress == self.captureMode){
//        [self.recordViewController pauseRecord];
//    }
}

- (void)captureProgressButtonAction:(UIButton *)sender{
    [self.recordViewController pauseRecord];
}

- (void)flipButtonAction:(UIButton *)sender{
    BOOL isFrontCamera = self.recordViewController.isFrontCamera;
    self.recordViewController.isFrontCamera = !isFrontCamera;
}

- (void)speedButtonAction:(UIButton *)sender{
    if (!self.speedSelectorView){
        self.speedSelectorView = [self createSpeedSelectorView];
        [self.view addSubview:self.speedSelectorView];
        [self.speedSelectorView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(16);
            make.right.offset(-16);
            make.height.mas_equalTo(SPEED_SELECTOR_HEIGHT);
            make.bottom.mas_equalTo(self.view.mas_safeAreaLayoutGuideBottom).offset(-170);
        }];
        
        self.speedSelectorView.hidden = YES;
        [self selectSpeedSelectorWithSpeed:self.recordViewController.recordSpeed];
    }
    self.speedSelectorView.hidden = !self.speedSelectorView.hidden;
    // 关闭可能打开的美颜
    [self hiddenPanelView];
}

- (void)selectSpeedSelectorWithSpeed:(TAVVideoRecordSpeedMode)speedMode{
    if (!self.speedSelectorView){
        return;
    }
    for (UIButton *btnItem in self.speedSelectorView.subviews) {
        btnItem.selected = NO;
        btnItem.backgroundColor = UIColor.clearColor;
    }
    UIButton *sender = [self.speedSelectorView viewWithTag:BUTTON_TAG_OFFSET + speedMode];
    sender.selected = YES;
    sender.backgroundColor = UIColor.whiteColor;
}

- (void)flashButtonAction:(UIButton *)sender{
    BOOL isFlash = self.recordViewController.isFlash;
    self.recordViewController.isFlash = !isFlash;
}

- (void)micButtonAction:(UIButton *)sender{
    BOOL isMic = self.recordViewController.isMic;
    self.recordViewController.isMic = !isMic;
}

- (void)beautyButtonAction:(UIButton *)sender{
    if (self.tePanelView && !self.tePanelView.isHidden) {
        [self hiddenPanelView];
    } else {
        [self showPanelView];
    }
    
    // 关闭可能打开的调速
    if (self.speedSelectorView && !self.speedSelectorView.hidden) {
        self.speedSelectorView.hidden = YES;
    }
}

- (void)speedModeButtonAction:(UIButton *)sender{
    if (sender.selected){
        return;
    }
    
    TAVVideoRecordSpeedMode speedMode = sender.tag - BUTTON_TAG_OFFSET;
    self.recordViewController.recordSpeed = speedMode;
}

- (void)mediaDiscardButtonAction:(UIButton *)sender{
    [self setVideoConfirmViewVisibility:NO];

    self.recordSwitchControl.hidden = NO;
    BOOL isStillMode = (CaptureModeStill == self.captureMode);
    if (isStillMode){
        [self onPhotoCancel];
    } else {
        [self.recordViewController discardRecord];
    }
}

- (void)mediaConfirmButtonAction:(UIButton *)sender{
    [self setVideoConfirmViewVisibility:NO];

    _clickConfirm = YES;
    BOOL isStillMode = (CaptureModeStill == self.captureMode);
    if (isStillMode){
        [self onPhotoFinished];
    } else {
        [self.recordViewController stopRecord];
    }
}

- (void)nextButtonAction:(UIButton *)sender{
    
}

// 通用设置view是否可用
- (void)setView:(UIView *)view isEnable:(BOOL)isEnable{
    if (isEnable){
        view.alpha = 1;
        view.userInteractionEnabled = YES;
    } else {
        view.alpha = 0.5;
        view.userInteractionEnabled = NO;
    }
}

- (void)setVideoConfirmViewVisibility:(BOOL)isVisible{
    if (isVisible) {
        if (!self.mediaDiscardButton){
            self.mediaDiscardButton = [self createVideoDiscardButton];
            [self.view addSubview:self.mediaDiscardButton];
            [self.mediaDiscardButton mas_makeConstraints:^(MASConstraintMaker *make) {
                make.width.height.mas_equalTo(40);
                make.centerY.equalTo(self.captureButton.mas_centerY);
                make.left.equalTo(self.captureButton.mas_right).offset(22);
            }];
            [self.mediaDiscardButton addTarget:self action:@selector(mediaDiscardButtonAction:) forControlEvents:UIControlEventTouchUpInside];
        }
        if (!self.videoConfirmButton){
            self.videoConfirmButton = [self createVideoConfirmButton];
            [self.view addSubview:self.videoConfirmButton];
            [self.videoConfirmButton mas_makeConstraints:^(MASConstraintMaker *make) {
                make.width.height.mas_equalTo(40);
                make.centerY.equalTo(self.captureButton.mas_centerY);
                make.left.equalTo(self.mediaDiscardButton.mas_right).offset(20);
            }];
            [self.videoConfirmButton addTarget:self action:@selector(mediaConfirmButtonAction:) forControlEvents:UIControlEventTouchUpInside];
        }
        
        self.videoConfirmButton.hidden = NO;
        self.mediaDiscardButton.hidden = NO;
        
    } else {
        if (self.mediaDiscardButton){
            self.mediaDiscardButton.hidden = YES;
        }
        if (self.videoConfirmButton){
            self.videoConfirmButton.hidden = YES;
        }
    }
}

- (void)setNextButtonViewVisibility:(BOOL)isVisible{
    if (isVisible){
        if (!self.nextButton){
            self.nextButton = [self createNextButton];
            [self.view addSubview:self.nextButton];
            [self.nextButton mas_makeConstraints:^(MASConstraintMaker *make) {
                make.bottom.equalTo(self.view.mas_safeAreaLayoutGuideBottom).offset(-15);
                make.right.offset(16);
            }];
            [self.nextButton addTarget:self action:@selector(nextButtonAction:) forControlEvents:UIControlEventTouchUpInside];
        }
        self.nextButton.hidden = NO;
    } else {
        if (!self.nextButton){
            return;
        }
        self.nextButton.hidden = YES;
    }
}

- (void)addSoundViewTapAction{
    if ([self.recordViewController isUsingBGM]){
        return;
    }
    __weak __typeof(self)weakSelf = self;
    [[self getMaterialProvider] getBgmWithHandler:^(TAVBgmResource *bgmResouce) {
        __weak __typeof(self)strongSelf = weakSelf;
        [strongSelf.addSoundView updateTitle:bgmResouce.bgmName];
        NSURL *musicURL = [NSURL fileURLWithPath:bgmResouce.path];
        AVAsset *asset = [AVURLAsset URLAssetWithURL:musicURL options:nil];
        [strongSelf.recordViewController setBGMAsset:asset];
    }];
}

- (void)addSoundViewDiscardAction{
    [self.recordViewController removeBGM];
}

- (void)onTapCaptureModeAction:(TAVSliderControl *)control{
    CaptureMode mode = (CaptureMode)control.selectedIndex;
    self.captureMode = mode;
}

#pragma mark - TakePhoto
- (void)onPhotoStarted{
    self.recordSwitchControl.hidden = YES;
    [self setView:self.captureButton isEnable:NO];
}

- (void)onPhotoComplete:(UIImage *)image{
    [self setVideoConfirmViewVisibility:YES];
    
    UIImageView *imageV = [self createPhotoPreviewImageViewWithImage:image];
    imageV.frame = self.recordViewController.view.frame;
    [self.view insertSubview:imageV aboveSubview:self.recordViewController.view];
    self.photoPreivewImageV = imageV;
    
    CGAffineTransform t = CGAffineTransformMakeScale(0.75, 0.75);
    [UIView animateWithDuration:0.3 animations:^{
        imageV.transform = t;
    } completion:nil];
}

- (void)onPhotoCancel{
    [self setView:self.captureButton isEnable:YES];
    
    [self.photoPreivewImageV removeFromSuperview];
    self.photoPath = nil;
}

- (void)onPhotoFinished{
    [self setView:self.captureButton isEnable:YES];
    self.recordSwitchControl.hidden = NO;
    
    [self.photoPreivewImageV removeFromSuperview];
    if (self.photoPath){
        TAVAlbumResource *resources = [[TAVAlbumResource alloc] initWithPath:self.photoPath forType:TAVResourcePhotoType];
        [self gotoPreviewControllerWithResource:@[resources]];
    }
}

#pragma mark - TAVRecordStatusDelegate
- (void)onRecordStarted:(TAVRecordViewController *)recordViewController {
    [self setView:self.addSoundView isEnable:NO];
    [self setView:self.beautyButton isEnable:NO];
    [self setView:self.micButton isEnable:NO];
    [self setVideoConfirmViewVisibility:NO];
    
    [self setView:self.speedButton isEnable:NO];
    self.speedSelectorView.hidden = YES;
    self.recordSwitchControl.hidden = YES;
    
    self.captureButton.hidden = YES;
    self.captureProgressButton.hidden = NO;
}
- (void)onRecordPaused:(TAVRecordViewController *)recordViewController{
    [self setView:self.addSoundView isEnable:YES];
    [self setView:self.beautyButton isEnable:YES];
    [self setView:self.micButton isEnable:YES];
    [self setVideoConfirmViewVisibility:YES];
    
    self.captureButton.hidden = NO;
    self.captureProgressButton.hidden = YES;
    
    // 时长太短不能确认
    self.videoConfirmButton.hidden = self.videoMilliSecond < MIN_VIDEO_DURATION * 1000;
}

- (void)onRecordProgress:(CGFloat)progress millSecond:(NSInteger)milliSecond{
    NSString *secondString = [NSString stringWithFormat:@"%.1fs", milliSecond / 1000.0];
    self.durationLabel.text = secondString;
    self.videoProgressView.progress = progress;
    self.captureProgressButton.progress = progress;
    self.videoMilliSecond = milliSecond;
}

- (void)onRecordFinished:(TAVRecordViewController *)recordViewController videoPath:(NSString *)path{
    [self setView:self.speedButton isEnable:YES];
    self.recordSwitchControl.hidden = NO;
    
    if (path) {
        TAVAlbumResource *resources = [[TAVAlbumResource alloc] initWithPath:path forType:TAVResourceVideoType];
        [self gotoPreviewControllerWithResource:@[resources]];
    }
    _clickConfirm = NO;
}
#pragma mark - Getter
- (MaterialProvider *)getMaterialProvider{
    if (!self.materialProvider){
        self.materialProvider = [MaterialProvider new];
    }
    return self.materialProvider;
}

#pragma mark - Setter
///  选拍照模式
- (void)setCaptureMode:(CaptureMode)captureMode
{
    _captureMode = captureMode;
    BOOL isStillMode = (captureMode == CaptureModeStill);
    
    [self setView:_speedButton isEnable:!isStillMode];
    self.speedSelectorView.hidden = YES;
    self.videoProgressView.hidden = isStillMode;
    self.durationLabel.hidden = isStillMode;
}

#pragma mark - UI
- (UIButton *)createCloseButton{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setImage:[UIImage imageNamed:@"tools_close"] forState:UIControlStateNormal];
    return btn;
}

- (UILabel *)createDureationLabel{
    UILabel *label = [[UILabel alloc] initWithFrame:CGRectZero];
    label.font = [UIFont systemFontOfSize:12];
    label.textColor = UIColor.whiteColor;
    label.textAlignment = NSTextAlignmentLeft;
    label.text = @"0.0s";
    return label;
}

- (TAVSimpleProgressView *)createVideoProgressView{
    TAVSimpleProgressView *progressView = [[TAVSimpleProgressView alloc] initWithFrame:CGRectZero];
    progressView.trackTintColor = [UIColor tvc_colorWithHexString:@"00000077"];
    progressView.tintColor = [UIColor tvc_colorWithHexString:@"#FFD876"];
    progressView.layer.cornerRadius = 3.0f;
    progressView.clipsToBounds = YES;
    return progressView;
}

- (CAShapeLayer *)createProgressLimitLine{
    CAShapeLayer *lineLayer = [CAShapeLayer layer];
    UIBezierPath *path = [UIBezierPath bezierPathWithRect:CGRectMake(0, 0, 1, 8)];
    lineLayer.path = path.CGPath;
    lineLayer.fillColor = [UIColor whiteColor].CGColor;
    return lineLayer;
}

- (UIStackView *)createMenuView{
    UIStackView *stackView = [[UIStackView alloc] initWithFrame:CGRectZero];
    stackView.axis = UILayoutConstraintAxisVertical;
    stackView.distribution = UIStackViewDistributionFillProportionally;
    stackView.alignment = UIStackViewAlignmentCenter;
    stackView.translatesAutoresizingMaskIntoConstraints = NO;
    stackView.spacing = 25;
    return stackView;
}

- (UIButton *)createMenuItemButtonWithImage:(UIImage *)image title:(NSString *)title{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_offset(57);
        make.height.mas_equalTo(39);
    }];
    // -7 = -(39 - 25) / 2;
    btn.imageEdgeInsets = UIEdgeInsetsMake(-7, 16, 7, 16);
    btn.titleEdgeInsets = UIEdgeInsetsMake(13, -25, -13, 0);
    [btn setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
    btn.titleLabel.textAlignment = NSTextAlignmentCenter;
    btn.titleLabel.font = [UIFont systemFontOfSize:10];
    
    [btn setImage:image forState:UIControlStateNormal];
    [btn setTitle:title forState:UIControlStateNormal];
    return btn;
}

- (UIButton *)createCaptureButton{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setImage:[UIImage imageNamed:@"record_normal"] forState:UIControlStateNormal];
    return btn;
}

- (TAVProgressButton *)captureCaptureProgressButton{
    TAVProgressButton *btn = [TAVProgressButton buttonWithType:UIButtonTypeCustom];
    return btn;
}

- (TAVVideoAddSoundView *)createAddSoundView{
    TAVVideoAddSoundView *addSoundV = [[TAVVideoAddSoundView alloc] initWithFrame:CGRectZero];
    return addSoundV;
}

- (UIStackView *)createSpeedSelectorView{
    UIStackView *stackView = [[UIStackView alloc] initWithFrame:CGRectZero];
    stackView.axis = UILayoutConstraintAxisHorizontal;
    stackView.distribution = UIStackViewDistributionFillEqually;
    stackView.translatesAutoresizingMaskIntoConstraints = NO;
    stackView.spacing = 0;
    stackView.backgroundColor = [UIColor colorWithWhite:0 alpha:0.5];
    stackView.layer.cornerRadius = SPEED_SELECTOR_HEIGHT * 0.5;
    stackView.clipsToBounds = YES;
    
    _speedDataSource = @[@[@(TAVVideoRecordSpeedMode_VerySlow), @"0.5x"],
                         @[@(TAVVideoRecordSpeedMode_Slow), @"0.8x"],
                         @[@(TAVVideoRecordSpeedMode_Standard), @"1x"],
                         @[@(TAVVideoRecordSpeedMode_Quick), @"1.25x"],
                         @[@(TAVVideoRecordSpeedMode_VeryQuick), @"2x"]];
    
    [_speedDataSource enumerateObjectsUsingBlock:^(NSArray *item, NSUInteger idx, BOOL * _Nonnull stop) {
        UIButton *btn = [self createSpeedItemButton];
        [btn setTitle:item[1] forState:UIControlStateNormal];
        [btn setTag:BUTTON_TAG_OFFSET + ((NSNumber *)item[0]).integerValue];
        [stackView addArrangedSubview:btn];
        [btn addTarget:self action:@selector(speedModeButtonAction:) forControlEvents:UIControlEventTouchUpInside];
    }];
    
    return stackView;
}

- (UIButton *)createSpeedItemButton{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.titleLabel.minimumScaleFactor = 0.5;
    [btn.titleLabel setFont:[UIFont systemFontOfSize:15]];
    btn.titleLabel.adjustsFontSizeToFitWidth = YES;
    [btn setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
    [btn setTitleColor:UIColor.blackColor forState:UIControlStateSelected];
    return btn;
}

- (UIButton *)createNextButton{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setTitle:@"Next" forState:UIControlStateNormal];
    btn.bounds = CGRectMake(0, 0, 75, 31);
    btn.backgroundColor = [UIColor tvc_colorWithHexString:@"#FF6500"];
    btn.layer.cornerRadius = 15.5;
    btn.layer.masksToBounds = YES;
    return btn;
}

- (UIButton *)createVideoDiscardButton{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setImage:[UIImage imageNamed:@"record_video_discard"] forState:UIControlStateNormal];
    return btn;
}

- (UIButton *)createVideoConfirmButton{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setImage:[UIImage imageNamed:@"record_video_confirm"] forState:UIControlStateNormal];
    return btn;
}

- (TAVSliderControl *)createRecordSwitchControl{
    TAVSliderControl *recordSwitchControl = [[TAVSliderControl alloc] initWithFrame:CGRectZero options:@[@"拍照", @"单击拍", @"长按拍"]];
    return recordSwitchControl;
}

- (UIImageView *)createPhotoPreviewImageViewWithImage:(UIImage *)image{
    UIImageView *imageV = [[UIImageView alloc] initWithImage:image];
    imageV.contentMode = UIViewContentModeScaleAspectFit;
    imageV.layer.cornerRadius = 8;
    imageV.layer.borderColor = UIColor.whiteColor.CGColor;
    imageV.layer.borderWidth = 3.0f;
    return imageV;
}

@end
