//
//  TAVProgressButton.m
//  TAVMagicApp
//
//  Created by v_zwtzzhou on 2025/6/26.
//

#import "TAVProgressButton.h"
#import <TAVMagicUIKit/UIColor+TAVUtil.h>

#define LINE_WIDTH 5.0

@interface TAVProgressButton ()
@property (nonatomic, strong) CAShapeLayer *trackLayer;
@property (nonatomic, strong) CAShapeLayer *progressLayer;
@end

@implementation TAVProgressButton

- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    // 设置默认值
    _progress = 0.0;
    [self setImage:[UIImage imageNamed:@"record_selected"] forState:UIControlStateNormal];
    self.imageView.contentMode = UIViewContentModeCenter;
    self.imageView.layer.cornerRadius = 3;
    self.imageView.clipsToBounds = YES;
    
    // 创建背景圆环
    _trackLayer = [CAShapeLayer layer];
    _trackLayer.fillColor = [[UIColor clearColor] CGColor];
    _trackLayer.strokeColor = [[UIColor tvc_colorWithHexString:@"#FF650026"] CGColor];
    _trackLayer.lineWidth = LINE_WIDTH;
    _trackLayer.lineCap = kCALineCapRound;
    [self.layer addSublayer:_trackLayer];
    
    // 创建进度圆环
    _progressLayer = [CAShapeLayer layer];
    _progressLayer.fillColor = [[UIColor clearColor] CGColor];
    _progressLayer.strokeColor = [[UIColor tvc_colorWithHexString:@"#FF6500"] CGColor];
    _progressLayer.lineWidth = LINE_WIDTH;
    _progressLayer.lineCap = kCALineCapRound;
    _progressLayer.strokeEnd = 0.0;
    [self.layer addSublayer:_progressLayer];
        
    // 设置视图属性
    self.backgroundColor = [UIColor clearColor];
}

#pragma mark - Layout

- (void)layoutSubviews {
    [super layoutSubviews];
    
    // 计算圆环路径
    CGRect bounds = self.bounds;
    CGFloat radius = (MIN(bounds.size.width, bounds.size.height) - LINE_WIDTH) / 2.0;
    CGPoint center = CGPointMake(bounds.size.width / 2.0, bounds.size.height / 2.0);
    
    UIBezierPath *circlePath = [UIBezierPath bezierPathWithArcCenter:center
                                                                  radius:radius
                                                              startAngle:-M_PI_2
                                                                endAngle:M_PI * 1.5
                                                               clockwise:YES];
    
    // 更新背景圆环
    _trackLayer.path = [circlePath CGPath];
    _trackLayer.frame = bounds;
    
    // 更新进度圆环
    _progressLayer.path = [circlePath CGPath];
    _progressLayer.frame = bounds;
    _progressLayer.strokeEnd = _progress;
}

#pragma mark - Progress Management

- (void)setProgress:(CGFloat)progress {
    [self setProgress:progress animated:NO];
}

- (void)setProgress:(CGFloat)progress animated:(BOOL)animated {
    [self setProgress:progress animated:animated duration:0.5];
}

- (void)setProgress:(CGFloat)progress animated:(BOOL)animated duration:(NSTimeInterval)duration {
    // 限制进度值范围
    progress = MAX(0.0, MIN(1.0, progress));
    
    if (animated) {
        CABasicAnimation *animation = [CABasicAnimation animationWithKeyPath:@"strokeEnd"];
        animation.duration = duration;
        animation.fromValue = @(_progress);
        animation.toValue = @(progress);
        animation.timingFunction = [CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionEaseInEaseOut];
        [_progressLayer addAnimation:animation forKey:@"strokeEndAnimation"];
    }
    
    _progress = progress;
    _progressLayer.strokeEnd = progress;
}

@end
