//
//  TAVSimpleProgressView.m
//  TAVMagicApp
//
//  Created by v_zwtzzhou on 2025/5/13.
//

#import "TAVSimpleProgressView.h"

@interface TAVSimpleProgressView () {
    float _progress;
}
@property (nonatomic, strong) UIView *tintView;
@end

@implementation TAVSimpleProgressView

- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self){
        [self setupUI];
    }
    return self;
}

- (void)setupUI{
    self.tintView = [[UIView alloc] initWithFrame:CGRectZero];
    [self addSubview:self.tintView];
}

- (void)layoutSubviews{
    [self refreshTintView];
}

- (void)refreshTintView{
    CGFloat width = self.bounds.size.width * _progress;
    self.tintView.frame = CGRectMake(0, 0, width, self.bounds.size.height);
}

#pragma mark - Setter & Getter
- (void)setProgress:(float)progress{
    progress = MAX(MIN(progress, 1), 0);
    _progress = progress;
    
    [self refreshTintView];
}

- (float)progress{
    return _progress;
}

- (void)setTrackTintColor:(UIColor *)trackTintColor{
    self.backgroundColor = trackTintColor;
}

- (UIColor *)trackTintColor{
    return self.backgroundColor;
}

- (void)setTintColor:(UIColor *)tintColor{
    self.tintView.backgroundColor = tintColor;
}

- (UIColor *)tintColor{
    return self.tintView.backgroundColor;
}

@end
