//
//  TAVVideoAddSoundView.m
//  TAVMagicApp
//
//  Created by v_zwtzzhou on 2025/5/27.
//

#import "TAVVideoAddSoundView.h"
#import <Masonry/Masonry.h>

#define VIEW_HEIGHT 34

@interface TAVVideoAddSoundView ()
@property (nonatomic, strong, readwrite) UILabel *titleLabel;
@property (nonatomic, strong, readwrite) UIImageView *iconImageView;
@property (nonatomic, strong, readwrite) UIButton *discardButton;
@property (nonatomic, copy, readwrite) NSString *titleString;
@property (nonatomic, strong) UIScrollView *contentView;
@property (nonatomic, strong) NSTimer *timer;
@end

@implementation TAVVideoAddSoundView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (instancetype)init{
    self = [super init];
    if (self){
        [self setupUI];
    }
    return self;
}

- (void)setupUI{
    self.backgroundColor = [UIColor colorWithWhite:0 alpha:0.5];
    self.layer.cornerRadius = VIEW_HEIGHT / 2;
    self.layer.masksToBounds = YES;
    
    self.titleLabel = [self createTitleLabel];
    self.contentView = [self createContentView];
    self.iconImageView = [self createIconImageView];
    [self addSubview:self.iconImageView];
    [self addSubview:self.contentView];
    [self.contentView addSubview:self.titleLabel];
    
    [self.iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(18);
        make.left.offset(15);
        make.centerY.mas_equalTo(self.mas_centerY);
    }];
    [self.contentView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(VIEW_HEIGHT);
        make.left.offset(38);
        make.right.offset(-15);
        make.centerY.mas_equalTo(self.mas_centerY);
    }];
    
    [self addTapGestureRecognizer];
}

- (void)addTapGestureRecognizer{
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(onTap:)];
    tap.numberOfTapsRequired = 1;
    tap.numberOfTouchesRequired = 1;
    [self addGestureRecognizer:tap];
}

- (void)didMoveToSuperview{
    [super didMoveToSuperview];
    [self updateTitle:self.titleString];
}

#pragma mark - Animal
- (void)startScrollTimer{
    __weak __typeof(self)weakSelf = self;
    self.timer = [NSTimer scheduledTimerWithTimeInterval:0.032 repeats:YES block:^(NSTimer * _Nonnull timer) {
        __strong typeof(self) strongSelf = weakSelf;
        [strongSelf scrollViewAutoScroll];
    }];
}

- (void)scrollViewAutoScroll{
    CGPoint offset = self.contentView.contentOffset;
    if (offset.x < self.contentView.contentSize.width - self.contentView.bounds.size.width){
        offset.x += 1;
    } else {
        offset.x = 0;
    }
    self.contentView.contentOffset = offset;
}

- (void)startAutoScroll{
    if (!self.timer){
        [self startScrollTimer];
    }
    [self.timer fire];
}

- (void)stopAutoScroll{
    if (!self.timer){
        return;
    }
    [self.timer invalidate];
}

#pragma mark - Data
- (NSString *)defaultTitleString{
    return NSLocalizedString(@"Recorder.Add sound", "添加音乐");;
}

- (void)updateTitle:(NSString *)title{
    if (!self.superview) {
        return;
    }

    self.titleString = title;
    if (nil == title) {
        title = [self defaultTitleString];
    }

    self.titleLabel.text = title;
    CGRect rect = CGRectMake(0, 0, 1000, VIEW_HEIGHT);
    CGRect stringRect = [self.titleLabel textRectForBounds:rect limitedToNumberOfLines:1];
    
    self.titleLabel.frame = CGRectMake(0, 0, stringRect.size.width, VIEW_HEIGHT);
    self.contentView.contentSize = CGSizeMake(stringRect.size.width, VIEW_HEIGHT);
    [self.contentView mas_updateConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(self.contentView.contentSize.width).priorityLow();
    }];
    
    if (self.titleString){
        [self showDiscardButton:YES];
        [self.contentView mas_updateConstraints:^(MASConstraintMaker *make) {
            make.right.offset(-42);
        }];
    } else {
        [self showDiscardButton:NO];
        [self.contentView mas_updateConstraints:^(MASConstraintMaker *make) {
            make.right.offset(-15);
        }];
    }
    
    CGFloat maxWidth = self.superview.bounds.size.width * 0.6;
    [self mas_updateConstraints:^(MASConstraintMaker *make) {
        make.width.mas_lessThanOrEqualTo(maxWidth);
        make.height.mas_equalTo(VIEW_HEIGHT);
    }];
    [self.contentView layoutIfNeeded];
    
    // Animation
    if (self.contentView.contentSize.width > self.contentView.bounds.size.width) {
        [self startAutoScroll];
    } else {
        [self stopAutoScroll];
    }
}

- (void)showDiscardButton:(BOOL)isShow{
    if (isShow) {
        if (!self.discardButton){
            self.discardButton = [self createDiscardButton];
            [self addSubview:self.discardButton];
            [self.discardButton mas_makeConstraints:^(MASConstraintMaker *make) {
                make.width.mas_equalTo(42);
                make.height.mas_equalTo(VIEW_HEIGHT);
                make.right.offset(0);
                make.centerY.mas_equalTo(self.mas_centerY);
            }];
            
            [self.discardButton addTarget:self action:@selector(discardButtonAction:) forControlEvents:UIControlEventTouchUpInside];
        }
        self.discardButton.hidden = NO;
    } else {
        if (!self.discardButton){
            return;
        }
        self.discardButton.hidden = YES;
    }
}

#pragma mark - Actions
- (void)onTap:(UITapGestureRecognizer *)tap{
    if (self.onTap){
        self.onTap();
    }
}

- (void)discardButtonAction:(UIButton *)sender{
    [self updateTitle:nil];
    if (self.onDiscard){
        self.onDiscard();
    }
}

#pragma mark - UI
- (UIImageView *)createIconImageView{
    UIImageView *iconV = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"sound_icon"] highlightedImage:nil];
    return iconV;
}

- (UILabel *)createTitleLabel{
    UILabel *titleV = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 10, VIEW_HEIGHT)];
    titleV.numberOfLines = 1;
    titleV.font = [UIFont systemFontOfSize:12];
    titleV.textColor = UIColor.whiteColor;
    return titleV;
}

- (UIScrollView *)createContentView{
    UIScrollView *scrollView = [[UIScrollView alloc] initWithFrame:CGRectZero];
    scrollView.showsVerticalScrollIndicator = NO;
    scrollView.showsHorizontalScrollIndicator = NO;
    return scrollView;
}

- (UIView *)createLineView{
    UIView *lineV = [[UIView alloc] init];
    lineV.backgroundColor = [UIColor colorWithWhite:0.33 alpha:0.5];
    return lineV;
}

- (UIButton *)createDiscardButton{
    UIButton *discardButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [discardButton setImage:[UIImage imageNamed:@"sound_discard"] forState:UIControlStateNormal];
    return discardButton;
}

@end
