//
//  ITAVEditInterceptor.h
//  Pods
//
//  Created by chavezchen on 2025/4/11.
//
#import <TAVMagicUIKit/TAVEditConstants.h>
#import <CoreMedia/CoreMedia.h>
#ifndef ITAVEditInterceptor_h
#define ITAVEditInterceptor_h


@protocol ITAVEditInterceptor <NSObject>

@optional
/// 是否可添加新轨道
/// - Parameters:
///   - type: 轨道类型
///   - currentCount: 当前已添加轨道数量
- (BOOL)canAddNewTrack:(TAVTrackType)type count:(NSInteger)currentCount;

/// 是否可添加新轨道
/// - Parameters:
///   - type: 轨道类型
///   - currentPosition: 当前时间点
///   - totalDuration: 总时长
- (BOOL)canAddNewTrack:(TAVTrackType)type
           currentTime:(CMTime)currentTime
              duration:(CMTime)totalDuration;

/// 是否可分割轨道
/// - Parameters:
///   - type: 轨道类型
///   - currentTime: 当前时间点
///   - timeRange: 当前轨道的时间范围
- (BOOL)canSplitTrack:(TAVTrackType)type
          currentTime:(CMTime)currentTime
            timeRange:(CMTimeRange)timeRange;

@end


#endif /* ITAVEditInterceptor_h */
