#import <UIKit/UIKit.h>
#import <TAVMagicUIKit/TAVAlbumDownloadAssetItem.h>
#import <TAVMagicUIKit/TAVAlbumPickerOptions.h>

NS_ASSUME_NONNULL_BEGIN

@class TAVAlbumAssetCollectionViewCell,TAVAlbumAsset,TAVAlbumProgressView;

#pragma mark - Protocol TAVAlbumAssetCollectionViewCellDelegate

@protocol TAVAlbumAssetCollectionViewCellDelegate <NSObject>

@optional

- (void)albumAssetCollectionViewCellClickPreview:(TAVAlbumAssetCollectionViewCell *)cell;
- (void)albumAssetCollectionViewCellClick:(TAVAlbumAssetCollectionViewCell *)cell;
- (void)albumAssetCollectionViewCellICloudDownloadComplete:(TAVAlbumAssetCollectionViewCell *)cell;
- (void)albumAssetCollectionViewCellClickAdd:(TAVAlbumAssetCollectionViewCell *)cell;

@end

@interface TAVAlbumAssetCollectionViewCell : UICollectionViewCell<TAVAlbumDownloadAssetItemDelegate>

@property (nonatomic, weak) id<TAVAlbumAssetCollectionViewCellDelegate> delegate;

/// @brief 相册展示模式
@property (nonatomic, assign) TAVAlbumPattern pattern;

/// @brief 是否已选满资源，如果已选满，则未选取的资源会有黑色蒙层
@property (nonatomic, assign) BOOL hasFill;

/// @brief 是否资源已导入
@property (nonatomic, assign) BOOL hasImported;

/// @brief 资源是横向的标识资源图
@property (nonatomic, strong) UIImage *horizontalIcon;

/// @brief 资源是纵向的标识资源图
@property (nonatomic, strong) UIImage *verticalIcon;

/// @brief 资源选中时的颜色
@property (nonatomic, strong) UIColor *selectedColor;

/// @brief 重载资源函数
- (void)configureWithData:(TAVAlbumAsset *)data;

/// @brief 播放选中时动画
- (void)showSelectAnimation;

/// @brief 配置当前选中资源的顺序
- (void)setOrder:(NSUInteger)order;

/// @brief 显示iCloud下载图层
- (void)showICloudProgressView;

/// @brief 配置最小选取时间
- (void)setMinTimeLimit:(NSTimeInterval)minTimeLimit;

@end

NS_ASSUME_NONNULL_END
