#import <Foundation/Foundation.h>

static const NSInteger gTAVAlbumDefaultAssetListColumn = 4;
static const CGFloat gTAVAlbumDefaultAssetListLineSpacing = 1.0;
static const CGFloat gTAVAlbumDefaultAssetListInteritemSpacing = 1.0;
static const CGFloat gTAVAlbumDefaultAssetListThumbnailSizeWidth = 0.0;
static const CGFloat gTAVAlbumDefaultAssetListInsetsValue = 0.0;

NS_ASSUME_NONNULL_BEGIN

@interface TAVAlbumGlobalOptions : NSObject

+ (TAVAlbumGlobalOptions *)shareInstance;

///*@brief 资源列表每排缩略图列数，默认值4个
@property (nonatomic, assign) NSInteger assetListColumn;

///*@brief 资源列表行间距,默认值1pt
@property (nonatomic, assign) CGFloat assetListLineSpacing;

///*@brief 资源列表每个item之间的间距,默认值1pt
@property (nonatomic, assign) CGFloat assetListInteritemSpacing;

///*@brief 资源列表边距,默认值(0,0,0,0)
@property (nonatomic, assign) UIEdgeInsets assetListEdgeInsets;

///*@brief 资源列表缩略图加载的像素精度值,默认为屏幕分辨率宽的1/assetListColumn
@property (nonatomic, assign) CGFloat assetListThumbnailSizeWidth;

@end

NS_ASSUME_NONNULL_END
