#import <UIKit/UIKit.h>
#import <TAVMagicUIKit/TAVAlbumAsset.h>
#import <TAVMagicUIKit/TAVAlbumPickerOptions.h>
#import <TAVMagicUIKit/TAVAlbumPickerControllerProtocol.h>

NS_ASSUME_NONNULL_BEGIN

@class TAVAlbumPickerController, TAVAlbumAssetViewController;

#pragma mark - Protocol TAVAlbumPickerControllerDelegate

@protocol TAVAlbumPickerControllerDelegate <NSObject>
@optional

/** @brief 用户选取照片完毕时的回调。如果本组件是通过present方式被呈现到界面上的话，此回调产生后，会顺便自动dismiss出界面。
    @param albumAssets 数组包含的是TAVAlbumAsset类型以及TVCMediaMaterialModel（素材库对象）的对象。
 */
- (void)albumPickerController:(TAVAlbumPickerController *)pickerController didFinishPickingAlbumAssets:(NSArray<TAVAlbumAssetProtocol> *)albumAssets;

///*@brief 取消选取时的回调。如果本组件是通过present方式被呈现到界面上的话，此回调产生后，会顺便自动dismiss出界面。
- (void)albumPickerControllerDidCancel:(TAVAlbumPickerController *)pickerController;

/** @brief 相册提示弹框，需宿主实现提示界面
    @param alertTips 提示内容
 */
- (void)albumPickerController:(TAVAlbumPickerController *)pickerController showAlertTips:(NSString *)alertTips;

/** @brief 用户点击特定按钮时选中照片视频的回调。如果本组件是通过present方式被呈现到界面上的话，此回调产生后，会顺便自动dismiss出界面。
    @param albumAssets 数组包含的是TAVAlbumAsset类型以及TVCMediaMaterialModel（素材库对象）的对象。
 */
- (void)albumPickerController:(TAVAlbumPickerController *)pickerController
didFinishPickingSpecialAlbumAssets:(NSArray<TAVAlbumAssetProtocol> *)albumAssets;

@end

@interface TAVAlbumPickerController : UINavigationController <TAVAlbumPickerControllerProtocol, UINavigationControllerDelegate>

///@brief 组件的代理
@property (nonatomic, weak) id<TAVAlbumPickerControllerDelegate> pickerDelegate;

@property (nonatomic, strong) TAVAlbumPickerContext *context;
@property (nonatomic, strong) TAVAlbumAssetSelectorBaseView *selectorView;
@property (nonatomic, strong) TAVAlbumAssetViewController *assetViewController;

- (instancetype)initWithOptions:(TAVAlbumPickerOptions *)options;
- (instancetype)initWithOptions:(TAVAlbumPickerOptions *)options rootViewController:(UIViewController *)rootViewController;

@end

NS_ASSUME_NONNULL_END
