#import <Foundation/Foundation.h>
#import <TAVMagicUIKit/TAVAlbumPickerContext.h>
#import <TAVMagicUIKit/TAVAlbumAssetProtocol.h>

@class TAVAlbumAssetSelectorBaseView;

NS_ASSUME_NONNULL_BEGIN

@protocol TAVAlbumPickerControllerObserver <NSObject>

@optional

//监听相册资源选取个数或者顺序发生改变
- (void)refreshVisibleCellsStateWithModel:(nullable NSObject <TAVAlbumAssetProtocol>*)model;

@end

@protocol TAVAlbumViewControllerProtocol <NSObject>

@optional

- (BOOL)hasDisplayAlbumAssetSelectorView;

@end

@protocol TAVAlbumPickerControllerProtocol <NSObject>

@required

@property (nonatomic, strong) TAVAlbumPickerContext *context;
@property (nonatomic, strong) TAVAlbumAssetSelectorBaseView *selectorView;

- (void)albumPickerControllerDidFinishPickingAlbumAssets:(NSArray <TAVAlbumAssetProtocol>*)albumAssets;
- (void)albumPickerControllerDidFinishPickingSpecialAlbumAssets:(NSArray <TAVAlbumAssetProtocol>*)albumAssets;
- (void)albumPickerControllerDidCancel;
- (void)albumPickerControllerShowAlertTips:(NSString *)alertTips;
- (void)selectAsset:(NSObject <TAVAlbumAssetProtocol>*)selectAsset;
- (void)postRefreshVisibleCellsStateWithModel:(nullable NSObject <TAVAlbumAssetProtocol>*)selectAsset;
- (void)addObserver:(id <TAVAlbumPickerControllerObserver>)observer;
- (void)removeObserver:(id <TAVAlbumPickerControllerObserver>)observer;

@end

NS_ASSUME_NONNULL_END
