#import <Foundation/Foundation.h>
#import <TAVMagicUIKit/TAVAlbumModel.h>
#import <TAVMagicUIKit/TAVAlbumAsset.h>

NS_ASSUME_NONNULL_BEGIN

extern NSString * const TAVAlbumPickerDidChangedNotification;
// WMMediaPickerDidChangedNotification 中携带的移除的Assets
extern NSString * const TAVAlbumPickerDeletedAssetsKey;
// WMMediaPickerDidChangedNotification 中携带的修改的Assets
extern NSString * const TAVAlbumPickerChangedAssetsKey;
// WMMediaPickerDidChangedNotification 是否包含删除和插入
extern NSString * const TAVAlbumPickerDeleteOrInsert;

extern NSString * const TAVAlbumPickerErrorDomain;
extern NSInteger const TAVAlbumPickerErrorCodeAuthority;
extern NSInteger const TAVAlbumPickerErrorCodeNotFound;

typedef void (^TAVAlbumLoadAlbumsBlock)(NSArray<TAVAlbumModel *> * _Nullable albums, NSError * _Nullable error);
typedef void (^TAVAlbumLoadAssetsBlock)(NSArray<TAVAlbumAsset *> * _Nullable assets, NSError * _Nullable error);
typedef void (^TAVAlbumLoadAssetBlock)(TAVAlbumAsset * _Nullable asset, NSError * _Nullable error);
typedef void(^TAVAlbumVoidBlock)(void);

@interface TAVAlbumPickerManager : NSObject

+ (TAVAlbumPickerManager *)shareInstance;

+ (TAVAlbumAssetType)mediaTypeFromPHAssetMediaType:(PHAssetMediaType)type;

// 预加载数据
- (void)preload;

/// 加载所有的相册
/// @param completion completion 主线程回调
- (void)loadAlbumsWithCompletion:(nullable TAVAlbumLoadAlbumsBlock)completion;

/// 为相册查询和填写媒体资源的数量以及相册中的最新的媒体资源
/// @param album 相册
/// @param type 资源类型
/// @param completion completion 主线程回调
- (void)loadAssetCountAndLatestAssetForAlbum:(TAVAlbumModel *)album
                                   mediaType:(TAVAlbumAssetType)type
                                  completion:(nullable TAVAlbumVoidBlock)completion;

/// 加载指定相册中的所有媒体资源
/// @param album 相册
/// @param type 类型
/// @param completion completion 主线程回调
- (void)loadAssetsWithAlbum:(TAVAlbumModel *)album
                  mediaType:(TAVAlbumAssetType)type
                 completion:(nullable TAVAlbumLoadAssetsBlock)completion;

/// 根据identifier加载指定的媒体资源
- (void)loadAssetWithIdentifier:(NSString *)identifier
                     completion:(nullable TAVAlbumLoadAssetBlock)completion;

//为指定类型的最新的媒体资源
- (void)loadLatestAssetForMediaType:(TAVAlbumAssetType)mediaType
                         completion:(nullable TAVAlbumLoadAssetBlock)completion;

- (void)applicationOpenSettings;

//创建相册控制器时调用
- (void)createAlbumController;

//释放相册控制器时调用
- (void)releaseAlbumController;

//清理相册资源缓存
- (void)clearCacheIfNeeded;

//相册是否有访问权限
- (BOOL)isPhotoLibraryAuthorized;

@end

NS_ASSUME_NONNULL_END
