#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class TAVAlbumAsset;
@class TAVAlbumPreviewCell;
@class TAVAlbumPreviewPlayerControlPanel;
@class TAVAlbumPreviewNavigationView;
@class TAVAlbumPreviewCell;
@class TAVAlbumPreviewViewController;
@class TAVAlbumPreviewListController;
@class TAVAlbumAssetSelectionSet;
@class TAVAlbumPickerContext;

#pragma mark - Protocol TAVAlbumPreviewViewControllerDelegate

@protocol TAVAlbumPreviewViewControllerDelegate <NSObject>

- (void)albumPreviewViewController:(TAVAlbumPreviewViewController *)albumPreviewListController
           addDownloadTaskWithCell:(TAVAlbumPreviewCell *)cell;

@optional

/// 通知外部应当关闭预览页，外部需要负责关闭预览页（可选）
/// 如果没有实现此方法，则页面会自动调用 navigationController 的 pop 方法
- (void)albumPreviewViewControllerShouldExit:(TAVAlbumPreviewViewController *)albumPreviewListController;

@end

@interface TAVAlbumPreviewViewController : UIViewController

@property (nonatomic, weak) id<TAVAlbumPreviewViewControllerDelegate> delegate;
@property (nonatomic, strong, readonly) TAVAlbumPreviewNavigationView *navigationView;
@property (nonatomic, strong, readonly) TAVAlbumPreviewPlayerControlPanel *controlPanel;
@property (nonatomic, strong, readonly) TAVAlbumPreviewListController *previewListController;

- (instancetype)initWithAppearIndex:(NSInteger)appearIndex
                      allAssetArray:(NSArray<TAVAlbumAsset*> *)allAssetArray
                   selectedAssetSet:(TAVAlbumAssetSelectionSet *)selectedAssetSet;

/// Deprecated
- (instancetype)initWithAppearIndex:(NSInteger)appearIndex assetArray:(NSArray<TAVAlbumAsset*> *)assetArray;

@end


@interface TAVAlbumPreviewViewController (CustomViews)

@property (nonatomic, strong, readonly) TAVAlbumPickerContext *context;

/// @brief 自定义创建"确定"的按钮样式
//若要自定义"确定"按钮，请重写这个方法
- (UIButton *)createFinishedButton;
/// 更新右上角按钮文字
- (void)updateCurrentOrderButton;
/// 子类重写
- (void)updateBottomViewAsset:(TAVAlbumAsset *)albumAsset order:(NSUInteger)order;
/// 子类重写
- (void)updateSelectorDataSource:(NSArray *)dataSource;

@end

NS_ASSUME_NONNULL_END
