#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN
// 资源类型
typedef NS_ENUM(NSUInteger, TAVResourceType) {
    TAVResourceBgmType,
    TAVResourcePhotoType,
    TAVResourceVideoType,
    TAVResourceMultiType
};
// 资源来源
typedef NS_ENUM(NSUInteger, TAVResourceFrom) {
    TAVResourceFromClip,   // 主轨
    TAVResourceFromPip     // 画中画
};

@interface TAVBaseResource : NSObject

/// 资源类型
@property (nonatomic, readonly) TAVResourceType type;
/// 资源路径
@property (nonatomic, readonly) NSString *path;
/// 资源名称
@property (nonatomic, readonly) NSString *name;
/// 资源时长
@property (nonatomic, readonly) NSTimeInterval duration;

- (instancetype)initWithPath:(NSString *)path forType:(TAVResourceType)type;
@end

NS_ASSUME_NONNULL_END
