//
//  TAVContainerController.h
//  TAVMagicUIKit
//
//  Created by Robin on 2024/9/4.
//

#import <UIKit/UIKit.h>
#import <TAVMagicUIKit/TAVContainerProtocols.h>

NS_ASSUME_NONNULL_BEGIN

@interface TAVContainerController<Context: id<ITAVContext>> : UIViewController<ITAVContainer>

@property (nonatomic, strong) Context context;

@property (nonatomic, copy, readonly) TAVLayoutName layoutName;

/// 初始化方法，根据不同的layoutName可以选择load不同的processor
- (instancetype)initWithLayoutName:(TAVLayoutName)layoutName;

- (Context)createContext;

- (NSArray<Class<ITAVProcessor>> *)needLoadProcessors;

- (Class<ITAVLayoutManager>)layoutManagerClass;

@end

NS_ASSUME_NONNULL_END
