//
//  TAVCoverSelectorController.h
//  AFNetworking
//
//  Created by penghuixu on 2025/2/7.
//

#import <UIKit/UIKit.h>
#import <TAVMagicUIKit/TAVFoundation.h>
@class TAVEditor;
NS_ASSUME_NONNULL_BEGIN

@protocol TAVCoverSelectorControllerDelegate <NSObject>
- (void)onSelectedCoverImg:(UIImage *)img atPosition:(CMTime)position;
@end


@interface TAVCoverSelectorController : UIViewController
@property (nonatomic, weak) id<TAVCoverSelectorControllerDelegate> delegate;
/// 实际使用用于抽帧范围的TimeRange
@property (nonatomic, assign) CMTimeRange useTimeRange;

- (instancetype)initWithEditor:(TAVEditor *)editor;
// 主动选择coverImg
- (void)selectCoverImgAtPosition:(CMTime)position;
@end

NS_ASSUME_NONNULL_END
