//
//  TAVEditorPreviewController.h
//  TAVMagicUIKit
//
//  Created by v_zwtzzhou on 2024/9/23.
//

#import <TAVMagicUIKit/TAVContainerController.h>
#import <TAVMagicUIKit/TAVEditorPreviewMenuView.h>
#import <TAVMagicUIKit/TAVPreviewBgmView.h>
#import <TAVMagicUIKit/TAVAlbumResource.h>
#import <TAVMagicUIKit/ITAVEditInterceptor.h>

extern NSString * const TAVKitButtonEventNotification;

@class TAVDraft,TAVEditor;
@protocol ITAVMaterialProvider;

@interface TAVEditorPreviewController : UIViewController
// 界面右侧一竖排按钮父视图
@property (nonatomic, readonly) TAVEditorPreviewMenuView *menuView;
// 背景音乐展示视图,默认隐藏
@property (nonatomic, readonly) TAVPreviewBgmView *bgmView;
// 返回按钮
@property (nonatomic, weak, readonly) UIButton *backButton;
// next按钮
@property (nonatomic, weak, readonly) UIButton *nextButton;
// next 按钮点击
@property (nonatomic, copy) void (^nextClickCallback)(void);
// 应该隐藏MenuView回调
@property (nonatomic, copy) void (^shouldHideMenuView)(void);
// 应该显示MenuView回调
@property (nonatomic, copy) void (^shouldShowMenuView)(void);
// 编辑sdk
@property (nonatomic, weak, readonly) TAVEditor *editor;
// 编辑最小时长，默认6s
@property (nonatomic, assign) NSTimeInterval minimumEditableDuration;
// 编辑最大时长，默认60 * 60s
@property (nonatomic, assign) NSTimeInterval maximumEditableDuration;
// 资源提供者，KIT内点击增加视频/图片/BGM时会调用该协议内的方法,可通过此协议自定义资源选择界面
@property (nonatomic, strong) id<ITAVMaterialProvider> materialProvider;
// 编辑拦截器，回调某些操作是否可继续的事件拦截
@property (nonatomic, strong) id<ITAVEditInterceptor> editInterceptor;

/// 初始化接口
/// - Parameters:
///   - assetPath: lightCore.bundle模型资源路径,传nil默认从mainBundle获取
///   - resources: 输入资源数组
- (instancetype)initWithAssetPath:(NSString *)assetPath resources:(NSArray <TAVAlbumResource *>*)resources;

/// 初始化接口
/// - Parameters:
///   - assetPath: lightCore.bundle模型资源路径,传nil默认从mainBundle获取
///   - draft: 草稿对象
- (instancetype)initWithAssetPath:(NSString *)assetPath draft:(TAVDraft *)draft;

/// 初始化接口
/// - Parameter editor: editor sdk对象
- (instancetype)initWithTavEditor:(TAVEditor *)editor;

/// 跳转编辑页
- (void)pushEditController;

/// 跳转编辑页并选中第一条bgm轨道
- (void)pushEditAndSelectBgmTrack;

/// 调起bgm选择面板，选择bgm
- (void)showBgmSelectionPanel;

/// 调起文字贴纸面板，添加文字贴纸
- (void)showTextInputPanel;

/// 调起音量设置面板，设置音量
- (void)showVolumePanel;

/// 跳转录音面板，添加录音
- (void)gotoVoiceoverPanel;

/// 业务记录的录音id，用于区分bgm与录音
- (NSArray *)voiceoverIds;

@end

