//
//  ITAVDraftManager.h
//  Pods
//
//  Created by chavezchen on 2024/10/31.
//

#import <Foundation/Foundation.h>
#import <TAVMagic/TAVDiffResult.h>
#import <TAVMagic/TAVDraft.h>
#import <TAVMagic/TAVDraftLoadingResult.h>

#ifndef ITAVDraftManager_h
#define ITAVDraftManager_h

typedef void(^TAVDraftActionCallBack)(NSString *tag,TAVDiffResult *diffResult,NSString *errMsg);
typedef void(^TAVDraftLoadingCallBack)(TAVDraftLoadingResult * draftLoadingResult);

@protocol ITAVDraftStateListener <NSObject>
/// 是否可撤销状态改变
- (void)onUndoStateChange:(BOOL)canUndo;
/// 是否可重做状态改变
- (void)onRedoStateChange:(BOOL)canRedo;
@end

@protocol ITAVDraftManager <NSObject, NSCopying>

/// 设置草稿存储路径，不设置则使用sdk内置的默认路径
/// - Parameter storageDir: 草稿存储路径
+ (void)setDraftStorageDir:(NSString *)storageDir;

/// 获取草稿列表
+ (NSArray<TAVDraft *> *)readDraftList;

/// 生成草稿到预设定目录，草稿使用到的资源(视频、图片、画中画、bgm、贴纸、滤镜等)会缓存到草稿目录，随着草稿删除一起删除
- (BOOL)generateDraft;
/// 生成草稿到预设定目录，不缓存草稿使用的资源，用户自己管理资源
- (BOOL)generateDraftNoCacheResources;

/// 获取当前草稿
- (TAVDraft *)getCurrentDraft;

/// 加载草稿
/// - Parameters:
///   - draft: 草稿对象
///   - shouldApply: 是否立即应用草稿效果
- (void)loadDraft:(TAVDraft *)draft onDraftLoadingFinished:(TAVDraftLoadingCallBack)callback;

/// 删除指定草稿
+ (void)deleteDraft:(TAVDraft *)draft;

/// 删除所有草稿
+ (void)deleteAllDrafts;

/// 重置/开始记录草稿
- (void)resetDraftRecord;

/// 提交一次草稿
/// - Parameter tag: 标记值
/// - return 提交是否成功
- (BOOL)commit:(NSString *)tag;

/// 当前是否可撤销
- (BOOL)canUndo;

/// 当前是否可重做
- (BOOL)canRedo;

/// 撤销/回退
- (void)undo:(TAVDraftActionCallBack)callback;

/// 重做/前进
- (void)redo:(TAVDraftActionCallBack)callback;

/// 添加&删除草稿监听状态
/// - Parameter listener: 监听者
- (void)addDraftStateListener:(id<ITAVDraftStateListener>)listener;
- (void)removeDraftStateListener:(id<ITAVDraftStateListener>)listener;

@end

#endif /* ITAVDraftManager_h */
