//
//  ITAVFrameProvider.h
//  Pods
//
//  Created by chavezchen on 2024/10/14.
//

#import <CoreMedia/CoreMedia.h>

#ifndef ITAVFrameProvider_h
#define ITAVFrameProvider_h

@class UIImage;

@protocol ITAVFrameProvider <NSObject>
/// 根据主轨道下标获取缩略图 - 异步
/// - Parameters:
///   - clipIndex: 资源文件下标
///   - count: 数量
///   - size: 缩略图宽高
///   - thumbCompletion: 回调返回对应缩略图数组
///   - return: Generateor 对象,可传入cancelGenerate:取消生成
- (id)getClipThumbnail:(int)clipIndex count:(int)count size:(CGSize)size completion:(void (^)(NSArray *images))thumbCompletion;

/// 根据主轨道下标获取pts对应的缩略图 - 异步
/// - Parameters:
///   - clipIndex: 资源文件索引
///   - pts: 时间
///   - size: 缩略图宽高
///   - thumbCompletion: 回调返回对应缩略图
///   - return: Generateor 对象,可传入cancelGenerate:取消生成
- (id)getClipThumbnail:(int)clipIndex pts:(CMTime)pts size:(CGSize)size completion:(void (^)(UIImage *image))thumbCompletion;

/// 根据主轨道下标获取pts对应的缩略图 - 同步
/// - Parameters:
///   - clipIndex: 资源文件索引
///   - pts: 时间
///   - size: 缩略图宽高
///   @return 当前帧缩略图
- (UIImage *)getClipThumbnail:(int)clipIndex pts:(CMTime)pts size:(CGSize)size;

/// 获取主轨pts对应的渲染结果帧 - 异步
/// @param pts 时间
/// @param isExportMode 是否导出模式：设置为YES，抽帧结果和导出一致。设置为NO，抽帧结果与预览一致。默认为NO。
/// @param length 最长边的长度，SDK内部会根据长边大小计算短边的大小
/// @param completion 回调
///   - return: Generateor 对象,可传入cancelGenerate:取消生成
- (id)getClipFrameAtTime:(CMTime)pts exportMode:(BOOL)isExportMode longSide:(CGFloat)length completion:(void (^)(UIImage *image))completion;
- (id)getClipFrameWithTimes:(NSArray <NSValue *>*)times exportMode:(BOOL)isExportMode longSide:(CGFloat)length completion:(void (^)(NSDictionary <NSValue *, UIImage *> *images))completion;
/// 获取主轨pts对应的渲染结果帧 - 同步
/// @param pts 时间
/// @param length 最长边的长度，SDK内部会根据长边大小计算短边的大小
- (UIImage *)getClipFrameAtTime:(CMTime)pts exportMode:(BOOL)isExportMode longSide:(CGFloat)length;
- (NSDictionary <NSValue *, UIImage *> *)getClipFrameWithTimes:(NSArray <NSValue *>*)times exportMode:(BOOL)isExportMode longSide:(CGFloat)length;
/// 获取缩略图
/// - Parameters:
///   - videoPath: 视频资源路径
///   - count: 数量
///   - size: 缩略图宽高
///   - timeRange: 视频时间抽帧范围，默认为整个视频时间范围
///   - thumbCompletion: 回调返回对应缩略图数组
///   - return: Generateor 对象,可传入cancelGenerate:取消生成
- (id)getThumbnail:(NSString *)videoPath
               count:(int)count
                size:(CGSize)size
           timeRange:(CMTimeRange)timeRange
          completion:(void (^)(NSArray<UIImage *> *images, NSError *error))thumbCompletion;

/// 获取pts对应的缩略图 - 异步
/// - Parameters:
///   - videoPath: 视频资源路径
///   - pts: 时间
///   - size: 缩略图宽高
///   - thumbCompletion: 回调返回对应缩略图数组
///   - return: Generateor 对象,可传入cancelGenerate:取消生成
- (id)getThumbnail:(NSString *)videoPath
                 pts:(CMTime)pts
                size:(CGSize)size
          completion:(void (^)(UIImage *image, NSError *error))thumbCompletion;

/// 获取pts对应的缩略图 - 同步
/// - Parameters:
///   - videoPath: 视频资源路径
///   - pts: 时间
///   - size: 缩略图宽高
- (UIImage *)getThumbnail:(NSString *)videoPath
                      pts:(CMTime)pts
                     size:(CGSize)size;

/// 取消生成缩略图
/// - Parameter generator:generator对象
- (void)cancelGenerate:(id)generator;

@end



#endif /* ITAVFrameProvider_h */
