//
//  ITAVPipManager.h
//  TAVMagic
//
//  Created by chavezchen on 2024/9/27.
//

#import <Foundation/Foundation.h>
#import <TAVMagic/TAVPipContextObserver.h>


@class TAVMediaPipItem,TAVPipView,TAVWidgetContentView;

@protocol ITAVPipViewDataSource <NSObject>

/// 根据画中画对象返回画中画视图，可继承自TAVPipView自定义控件,不实现默认使用sdk自带的
/// - Parameter TAVMediaPipItem: 画中画对象
- (TAVPipView *)pipViewWithPipItem:(TAVMediaPipItem *)pipItem;


@end


@protocol ITAVPipManager <NSObject>

- (void)setPipViewDataSource:(id<ITAVPipViewDataSource>)dataSource;

/// 创建画中画
/// - Parameters:
///   - filePath: 画中画路径
///   - mediaType: 资源类型，0:视频，1:图片
- (TAVMediaPipItem *)createPipItem:(NSString *)filePath mediaType:(NSInteger)mediaType;

/// 添加画中画
/// - Parameter pipItem: 画中画对象
- (void)loadPip:(TAVMediaPipItem *)pipItem;

/// 删除指定画中画
/// - Parameter pipItem: 画中画对象
- (void)removePip:(TAVMediaPipItem *)pipItem;

- (void)removeCurrentPip;

- (void)removeAllPip;

- (NSArray<TAVMediaPipItem *> *)getAllPipItems;

- (void)addPipObserver:(id<TAVPipContextObserver>)observer;

- (void)removePipObserver:(id<TAVPipContextObserver>)observer;

- (TAVMediaPipItem *)getCurrentPipItem;

- (void)activePip:(TAVMediaPipItem *)pipItem;

- (void)resignPip:(TAVMediaPipItem *)pipItem;

- (void)resignCurrentPip;
// 通过pipItem,查找对应的pipView
- (TAVPipView *)fetchPipView:(TAVMediaPipItem *)pipItem;

@end

