//
//  ITAVStickerManager.h
//  Pods
//
//  Created by chavezchen on 2024/4/8.
//

#ifndef ITAVStickerManager_h
#define ITAVStickerManager_h
#import <UIKit/UIKit.h>

typedef NS_ENUM(NSUInteger, TAVStickerItemType) {
    TAVStickerItemTypeMotion             = 0,                    /**< 动效贴纸 */
    TAVStickerItemTypeText               = 1,                    /**< 文字贴纸 */
    TAVStickerItemTypeImage              = 2,                    /**< 图片贴纸 */
};

typedef NS_ENUM(NSUInteger, TAVStickerItemImageSubType) {
    TAVStickerItemImageSubType_unkown            = 0,            // 未知类型
    TAVStickerItemImageSubType_image             = 1,            // 静态图片类型
    TAVStickerItemImageSubType_gif               = 2,            // gif图片
    TAVStickerItemImageSubType_apng              = 3,            // apng图片
};

@protocol TAVStickerContextObserver;
@class TAVMediaStickerItem,TAVSticker,TAVStickerView,TAVWidgetContentView;


@protocol ITAVStickerViewDataSource <NSObject>

/// 根据贴纸对象返回贴纸视图，可继承自TAVStickerView自定义某些控件
/// - Parameter stickerItem: 贴纸对象
- (TAVStickerView *)stickerViewWithStickerItem:(TAVMediaStickerItem *)stickerItem;


@end

@protocol ITAVStickerManager <NSObject>

/// 设置贴纸的视图数据源
/// - Parameter dataSource: datasource，需要实现stickerViewWithStickerItem方法，返回贴纸视图
- (void)setStickerViewDataSource:(id<ITAVStickerViewDataSource>)dataSource;

/// 创建贴纸item
/// - Parameter stickerPath: 贴纸路径
- (TAVMediaStickerItem *)createStickerItem:(NSString *)stickerPath stickerType:(TAVStickerItemType)stickerItemType;

/// 加载贴纸
/// - Parameter stickerItem: 贴纸对象
- (void)loadStickerItem:(TAVMediaStickerItem *)stickerItem;

/// 删除贴纸对象
/// - Parameter stickerItem: 贴纸对象
- (void)removeStickerItem:(TAVMediaStickerItem *)stickerItem;

/// 删除所有贴纸对象
- (void)removeAllStickerItem;

/// 删除当前贴纸
- (void)removeCurrentSticker;

/// 获取当前贴纸Item
- (TAVMediaStickerItem *)getCurrentStickerItem;

/// 获取所有贴纸Item
- (NSArray <TAVMediaStickerItem *>*)getAllStickerItems;

/// 根据sticker获取对应贴纸item
/// - Parameter sticker: sticker
- (TAVMediaStickerItem *)getStickerItemWithSticker:(TAVSticker *)sticker;

/// 获取当前贴纸
- (TAVSticker *)getCurrentSticker;

/// 获取当前贴纸视图
- (TAVStickerView *)getCurrentStickerView;

/// 通过sticker获取对应贴纸视图
- (TAVStickerView *)fetchStickerView:(TAVSticker *)sticker;
- (TAVStickerView *)fetchStickerVIewWithItem:(TAVMediaStickerItem *)stickerItem;

/// 添加贴纸观察者
/// - Parameter observer: 观察者
- (void)addStickerObserver:(id<TAVStickerContextObserver>)observer;

/// 删除贴纸观察者
/// - Parameter observer: 观察者
- (void)removeStickerObserver:(id<TAVStickerContextObserver>)observer;

/// 激活贴纸（隐藏渲染层的贴纸、显示stickerContentView上对应的贴纸）
/// - Parameter stickerItem: 贴纸item
- (void)activeStickerItem:(TAVMediaStickerItem *)stickerItem;

/// 注销贴纸（显示渲染层的贴纸、隐藏stickerContentView上对应的贴纸）
/// - Parameter stickerItem: 贴纸item
- (void)resignStickerItem:(TAVMediaStickerItem *)stickerItem;

/// 注销当前贴纸
- (void)resignCurrentStickerItem;

/// 注销所有贴纸
- (void)resignAllStickerItems;

// 获取当前的VideoRect
- (CGRect)currentVideoRect;

@end



#endif /* ITAVStickerManager_h */
