//
//  NSObject+TAVMD5.h
//  TAVCut
//
//  Created by hugoyao on 2020/9/23.
//  Copyright © 2020 tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface NSObject (TAVMD5)

// 专门负责Md5生成的系列函数
- (id)modelToJSONObjectForMd5;
- (nullable NSData *)modelToJSONDataForMd5;
- (nullable NSString *)modelToJSONStringForMd5;

@end

@protocol YYModelForMd5 <NSObject>
@optional

// 以下函数都只针对当前类，如需父类的转换结果，需要在函数中用super进行调用
// 在原来modelCustomTransformToDictionary之后运行，可以在这里对生成Md5的属性增删改
- (BOOL)modelCustomTransformToDictionaryForMd5:(NSMutableDictionary *)dic;

@end

NS_ASSUME_NONNULL_END
