//
//  TAVBlurSticker.h
//  TAVCut
//
//  Created by Aoz on 2020/8/12.
//  Copyright © 2020 Tencent. All rights reserved.
//

#import "TAVSticker.h"

typedef NS_ENUM(NSInteger, TAVBlurStickerStyle) {
    TAVBlurStickerStyleGaussian,
    TAVBlurStickerStyleInpainting,
    TAVBlurStickerStyleMAXCount,
};

NS_ASSUME_NONNULL_BEGIN

@interface TAVBlurSticker : TAVSticker <NSCopying>

@property ( nonatomic, copy ) NSString *descImagePath;
@property ( nonatomic, strong, readonly ) UIImage *descImage;

@property ( nonatomic, copy ) NSString *textureImagePath;
@property ( nonatomic, strong, readonly ) UIImage *textureImage;

@property (nonatomic, assign) TAVBlurStickerStyle blurStyleType;

//是否需要用pagFile的尺寸比例来显示贴纸大小，初始化后赋值，业务层自己调用，默认YES
//例如添加模糊贴纸初始化的时候需要设为YES，但从草稿箱的时候恢复的时候不需要
@property (nonatomic, assign) BOOL shouldUsePagFileSizeRatio;

- (void)loadFiles;

@end

NS_ASSUME_NONNULL_END
