//
//  TAVDraft.h
//  TAVMagic
//
//  Created by chavezchen on 2024/10/17.
//

#import <Foundation/Foundation.h>
#import <TAVMagic/TAVDraftBgm.h>
#import <TAVMagic/TAVDraftClipSource.h>
#import <TAVMagic/TAVDraftLut.h>
#import <TAVMagic/TAVDraftMotion.h>
#import <TAVMagic/TAVDraftPip.h>
#import <TAVMagic/TAVDraftSticker.h>
#import <TAVMagic/TAVDiffResult.h>


NS_ASSUME_NONNULL_BEGIN

@interface TAVDraft : NSObject<NSCopying>

@property (nonatomic, copy) NSString *commitTag;
/// 自定义内容
@property (nonatomic, strong) NSMutableDictionary *extraInfo;
/// 获取草稿缩略图
- (NSString *)getThumbPath;
/// 设置草稿缩略图
- (void)setThumbnail:(NSString *)path;
/// 获取草稿json缓存路径
- (NSString *)getDraftJsonPath;
/// 通过草稿json初始化draft对象
/// - Parameter jsonPath: 草稿json路径
+ (instancetype)draftWithJsonPath:(NSString *)jsonPath;
- (instancetype)fork;
///
- (TAVDraftComponent *)getComponent:(int)componentId type:(TAVDraftComponentType)type;
/// 草稿差异化对比
- (TAVDiffResult *)diffDraft:(TAVDraft *)willApplyDraft;
@end

NS_ASSUME_NONNULL_END
